<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Timeline - {{ $application->jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                
                <!-- Back Button -->
                <div class="mb-4">
                    <a href="{{ route('candidate.track', $application->tracking_token) }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Dashboard
                    </a>
                </div>

                <!-- Header -->
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <h2 class="mb-1">Application Timeline</h2>
                        <p class="text-muted mb-0">{{ $application->jobPosting->title }}</p>
                    </div>
                </div>

                <!-- Timeline -->
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-clock-history"></i> Status History</h5>
                    </div>
                    <div class="card-body">
                        @if($application->statusHistory->count() > 0)
                        <div class="timeline">
                            @foreach($application->statusHistory->reverse() as $history)
                            <div class="d-flex mb-4 pb-3 border-bottom">
                                <div class="flex-shrink-0">
                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center" 
                                         style="width: 40px; height: 40px;">
                                        <i class="bi bi-arrow-right"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1">
                                        @if($history->from_status)
                                            Status changed from <span class="badge bg-secondary">{{ ucfirst($history->from_status) }}</span>
                                            to <span class="badge bg-primary">{{ ucfirst($history->to_status) }}</span>
                                        @else
                                            Application submitted
                                        @endif
                                    </h6>
                                    <p class="text-muted small mb-1">
                                        <i class="bi bi-calendar"></i> {{ $history->created_at->format('F j, Y \a\t g:i A') }}
                                        ({{ $history->created_at->diffForHumans() }})
                                    </p>
                                    @if($history->changedBy)
                                    <p class="text-muted small mb-1">
                                        <i class="bi bi-person"></i> Updated by {{ $history->changedBy->name }}
                                    </p>
                                    @endif
                                    @if($history->notes)
                                    <p class="small mb-0">
                                        <i class="bi bi-chat-left-text"></i> {{ $history->notes }}
                                    </p>
                                    @endif
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @else
                        <p class="text-muted text-center py-4">No status history available yet.</p>
                        @endif
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
