<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Messages - {{ $application->jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                
                <div class="mb-4">
                    <a href="{{ route('candidate.track', $application->tracking_token) }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Dashboard
                    </a>
                </div>

                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show">
                    <i class="bi bi-check-circle"></i> {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif

                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-chat-dots"></i> Messages</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <h6>{{ $application->jobPosting->title }}</h6>
                            <p class="text-muted small mb-0">{{ $application->jobPosting->organization->name }}</p>
                        </div>

                        <div class="messages-container" style="max-height: 500px; overflow-y: auto;">
                            @forelse($messages as $message)
                            <div class="message mb-3 {{ $message->isFromHR() ? 'text-start' : 'text-end' }}">
                                <div class="d-inline-block" style="max-width: 75%;">
                                    <div class="card {{ $message->isFromHR() ? 'bg-light' : 'bg-primary text-white' }}">
                                        <div class="card-body py-2 px-3">
                                            <p class="mb-1">{{ $message->message }}</p>
                                            <small class="{{ $message->isFromHR() ? 'text-muted' : 'text-white-50' }}">
                                                @if($message->isFromHR())
                                                    <i class="bi bi-person-badge"></i> {{ $message->sender->name ?? 'HR Team' }}
                                                @else
                                                    <i class="bi bi-person"></i> You
                                                @endif
                                                · {{ $message->created_at->diffForHumans() }}
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @empty
                            <div class="text-center text-muted py-5">
                                <i class="bi bi-chat-dots fs-1"></i>
                                <p class="mt-2">No messages yet. Start a conversation below!</p>
                            </div>
                            @endforelse
                        </div>
                    </div>
                </div>

                <div class="card shadow-sm">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="bi bi-send"></i> Send Message</h6>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('candidate.messages.store', $application->tracking_token) }}">
                            @csrf
                            <div class="mb-3">
                                <textarea class="form-control" name="message" rows="4" 
                                          placeholder="Type your message here..." required maxlength="2000">{{ old('message') }}</textarea>
                                <div class="form-text">Maximum 2000 characters</div>
                                @error('message')
                                <div class="text-danger small">{{ $message }}</div>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-send"></i> Send Message
                            </button>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto-scroll to bottom of messages
        const container = document.querySelector('.messages-container');
        if (container) {
            container.scrollTop = container.scrollHeight;
        }
    </script>
</body>
</html>
