<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Track Your Application - {{ $application->jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                
                @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif

                @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle"></i> {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                @endif

                <!-- Header Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h2 class="mb-1">{{ $application->full_name }}</h2>
                                <p class="text-muted mb-0"><i class="bi bi-envelope"></i> {{ $application->email }}</p>
                            </div>
                            <div class="col-md-4 text-md-end mt-3 mt-md-0">
                                <span class="badge 
                                    @if($application->status === 'new') bg-primary
                                    @elseif($application->status === 'screening') bg-warning
                                    @elseif($application->status === 'shortlisted') bg-info
                                    @elseif($application->status === 'interviewed') bg-secondary
                                    @elseif($application->status === 'offered') bg-success
                                    @elseif($application->status === 'rejected') bg-danger
                                    @elseif($application->status === 'withdrawn') bg-secondary
                                    @else bg-secondary
                                    @endif fs-6 px-3 py-2">
                                    {{ ucfirst($application->status) }}
                                </span>
                                <p class="text-muted small mt-2 mb-0">
                                    Applied {{ $application->applied_at->diffForHumans() }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Job Details Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-briefcase"></i> Position Applied For</h5>
                    </div>
                    <div class="card-body">
                        <h4 class="text-primary mb-2">{{ $application->jobPosting->title }}</h4>
                        <p class="text-muted mb-3">{{ $application->jobPosting->organization->name }}</p>
                        
                        <div class="row text-muted">
                            @if($application->jobPosting->department)
                            <div class="col-md-4 mb-2">
                                <i class="bi bi-building"></i> {{ $application->jobPosting->department->name }}
                            </div>
                            @endif
                            <div class="col-md-4 mb-2">
                                <i class="bi bi-geo-alt"></i> {{ $application->jobPosting->location }}
                            </div>
                            <div class="col-md-4 mb-2">
                                <i class="bi bi-clock"></i> {{ ucfirst($application->jobPosting->employment_type) }}
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Next Steps Alert -->
                <div class="alert alert-info" role="alert">
                    <h5 class="alert-heading"><i class="bi bi-info-circle"></i> What's Next?</h5>
                    <p class="mb-0">{{ $application->next_steps }}</p>
                </div>

                <!-- Progress Tracker Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-graph-up"></i> Application Progress</h5>
                    </div>
                    <div class="card-body">
                        @php
                            $steps = [
                                'new' => ['title' => 'Application Submitted', 'desc' => 'Your application has been received', 'icon' => 'check-circle'],
                                'screening' => ['title' => 'Under Review', 'desc' => 'Our team is reviewing your application', 'icon' => 'eye'],
                                'shortlisted' => ['title' => 'Shortlisted', 'desc' => 'You have been selected for interview', 'icon' => 'star'],
                                'interviewed' => ['title' => 'Interview Completed', 'desc' => 'Making final decision', 'icon' => 'people'],
                                'offered' => ['title' => 'Offer Extended', 'desc' => 'Congratulations!', 'icon' => 'trophy'],
                            ];
                            
                            $statusOrder = ['new', 'screening', 'shortlisted', 'interviewed', 'offered'];
                            $currentIndex = array_search($application->status, $statusOrder);
                            if ($currentIndex === false) $currentIndex = 0;
                        @endphp
                        
                        <div class="position-relative">
                            @foreach($steps as $status => $step)
                                @php
                                    $stepIndex = array_search($status, $statusOrder);
                                    $isCompleted = $stepIndex <= $currentIndex;
                                    $isCurrent = $status === $application->status;
                                @endphp
                                
                                <div class="d-flex align-items-start mb-4 position-relative">
                                    <div class="flex-shrink-0">
                                        <div class="rounded-circle d-flex align-items-center justify-content-center 
                                            @if($isCompleted) bg-success text-white @else bg-secondary text-white @endif"
                                            style="width: 40px; height: 40px;">
                                            @if($isCompleted)
                                                <i class="bi bi-check-lg fs-5"></i>
                                            @else
                                                <i class="bi bi-circle fs-6"></i>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <h6 class="mb-1 @if($isCompleted) text-dark @else text-muted @endif">
                                            {{ $step['title'] }}
                                        </h6>
                                        <p class="mb-1 small @if($isCompleted) text-secondary @else text-muted @endif">
                                            {{ $step['desc'] }}
                                        </p>
                                        @if($isCurrent)
                                        <span class="badge bg-primary">Current Stage</span>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

                <!-- Interviews Section -->
                @if($application->interviews->count() > 0)
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0"><i class="bi bi-calendar-event"></i> Scheduled Interviews</h5>
                    </div>
                    <div class="card-body">
                        @foreach($application->interviews as $interview)
                        <div class="border rounded p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-start flex-wrap">
                                <div class="mb-2">
                                    <h6 class="mb-1">Interview with {{ $interview->interviewer->name }}</h6>
                                    <p class="text-muted small mb-1">
                                        <i class="bi bi-calendar"></i> {{ $interview->scheduled_at->format('l, F j, Y \a\t g:i A') }}
                                    </p>
                                    @if($interview->location)
                                    <p class="text-muted small mb-1">
                                        <i class="bi bi-geo-alt"></i> {{ $interview->location }}
                                    </p>
                                    @endif
                                    @if($interview->meeting_link)
                                    <a href="{{ $interview->meeting_link }}" target="_blank" class="btn btn-sm btn-primary mt-2">
                                        <i class="bi bi-camera-video"></i> Join Virtual Meeting
                                    </a>
                                    @endif
                                </div>
                                <span class="badge 
                                    @if($interview->status === 'scheduled') bg-primary
                                    @elseif($interview->status === 'completed') bg-success
                                    @else bg-secondary
                                    @endif">
                                    {{ ucfirst($interview->status) }}
                                </span>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <!-- Job Offer Section -->
                @if($application->jobOffer && $application->jobOffer->status !== 'draft')
                <div class="card shadow-sm mb-4 border-success">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="bi bi-trophy"></i> Job Offer</h5>
                    </div>
                    <div class="card-body">
                        @if($application->jobOffer->status === 'sent')
                        <div class="alert alert-success mb-3">
                            <h5 class="alert-heading"><i class="bi bi-check-circle"></i> Congratulations!</h5>
                            <p class="mb-0">You have received a job offer for the position of <strong>{{ $application->jobOffer->position_title }}</strong>.</p>
                        </div>
                        
                        <div class="mb-3">
                            <h6>Offer Details:</h6>
                            <ul class="list-unstyled">
                                <li><strong>Position:</strong> {{ $application->jobOffer->position_title }}</li>
                                <li><strong>Salary:</strong> ${{ number_format($application->jobOffer->salary, 2) }} per {{ $application->jobOffer->salary_period }}</li>
                                <li><strong>Start Date:</strong> {{ $application->jobOffer->start_date->format('F j, Y') }}</li>
                                @if($application->jobOffer->expires_at)
                                <li><strong>Offer Valid Until:</strong> {{ $application->jobOffer->expires_at->format('F j, Y') }}</li>
                                @endif
                            </ul>
                        </div>

                        <div class="d-flex gap-2 flex-wrap">
                            <a href="{{ route('offer.view', $application->jobOffer->offer_token) }}" 
                               class="btn btn-success btn-lg">
                                <i class="bi bi-eye"></i> View Full Offer
                            </a>
                            <a href="{{ route('offer.accept', $application->jobOffer->offer_token) }}" 
                               class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle"></i> Accept Offer
                            </a>
                            <a href="{{ route('offer.decline', $application->jobOffer->offer_token) }}" 
                               class="btn btn-outline-danger btn-lg">
                                <i class="bi bi-x-circle"></i> Decline Offer
                            </a>
                        </div>
                        @elseif($application->jobOffer->status === 'accepted')
                        <div class="alert alert-success">
                            <h5 class="alert-heading"><i class="bi bi-check-circle"></i> Offer Accepted</h5>
                            <p class="mb-0">You accepted this offer on {{ $application->jobOffer->responded_at->format('F j, Y') }}.</p>
                            <p class="mb-0 mt-2">Your start date is <strong>{{ $application->jobOffer->start_date->format('F j, Y') }}</strong>.</p>
                        </div>
                        <a href="{{ route('offer.view', $application->jobOffer->offer_token) }}" 
                           class="btn btn-outline-primary">
                            <i class="bi bi-eye"></i> View Offer Details
                        </a>
                        @elseif($application->jobOffer->status === 'declined')
                        <div class="alert alert-secondary">
                            <h5 class="alert-heading"><i class="bi bi-info-circle"></i> Offer Declined</h5>
                            <p class="mb-0">You declined this offer on {{ $application->jobOffer->responded_at->format('F j, Y') }}.</p>
                        </div>
                        @endif
                    </div>
                </div>
                @endif

                <!-- Application Details Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-file-text"></i> Your Application</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Contact Information</label>
                            <p class="mb-0"><i class="bi bi-phone"></i> {{ $application->phone }}</p>
                        </div>
                        
                        @if($application->cover_letter)
                        <div class="mb-3">
                            <label class="form-label fw-bold">Cover Letter</label>
                            <p class="text-muted" style="white-space: pre-line;">{{ $application->cover_letter }}</p>
                        </div>
                        @endif
                        
                        <div class="mb-0">
                            <label class="form-label fw-bold">Resume/CV</label>
                            <div class="mt-2">
                                <a href="{{ route('candidate.cv.download', $application->tracking_token) }}" 
                                   class="btn btn-outline-primary">
                                    <i class="bi bi-download"></i> Download CV
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Actions Card -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="bi bi-gear"></i> Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex flex-wrap gap-2">
                            <a href="{{ route('candidate.messages', $application->tracking_token) }}" 
                               class="btn btn-primary">
                                <i class="bi bi-chat-dots"></i> Messages
                                @if($application->messages()->where('sender_type', 'hr')->where('read_by_candidate', false)->count() > 0)
                                <span class="badge bg-danger">{{ $application->messages()->where('sender_type', 'hr')->where('read_by_candidate', false)->count() }}</span>
                                @endif
                            </a>
                            
                            @if($application->canBeUpdated())
                            <a href="{{ route('candidate.edit', $application->tracking_token) }}" 
                               class="btn btn-outline-primary">
                                <i class="bi bi-pencil"></i> Update Application
                            </a>
                            @endif
                            
                            <a href="{{ route('candidate.timeline', $application->tracking_token) }}" 
                               class="btn btn-outline-secondary">
                                <i class="bi bi-clock-history"></i> View Timeline
                            </a>
                            
                            @if($application->canBeWithdrawn())
                            <a href="{{ route('candidate.withdraw', $application->tracking_token) }}" 
                               class="btn btn-outline-danger">
                                <i class="bi bi-x-circle"></i> Withdraw Application
                            </a>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Help Section -->
                <div class="text-center text-muted">
                    <p class="mb-1">Questions about your application?</p>
                    @php
                        $contactEmail = $application->jobPosting->organization->getSetting('contact_email') 
                                     ?? $application->jobPosting->organization->getSetting('hr_email')
                                     ?? 'hr@' . str_replace(' ', '', strtolower($application->jobPosting->organization->name)) . '.com';
                        $website = $application->jobPosting->organization->getSetting('company_website') 
                                ?? $application->jobPosting->organization->getSetting('website')
                                ?? '#';
                    @endphp
                    <p>Contact us at <a href="mailto:{{ $contactEmail }}" class="text-primary">{{ $contactEmail }}</a></p>
                    @if($website !== '#')
                    <p><a href="{{ $website }}" target="_blank" class="text-primary"><i class="bi bi-globe"></i> Visit Our Website</a></p>
                    @endif
                </div>

            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
