<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Decline Offer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                
                <div class="card shadow-sm">
                    <div class="card-header bg-danger text-white">
                        <h5 class="mb-0"><i class="bi bi-exclamation-triangle"></i> Decline Job Offer</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <strong>Are you sure?</strong> This action cannot be undone.
                        </div>

                        <p>You are about to decline the offer for:</p>
                        <div class="bg-light p-3 rounded mb-4">
                            <h6 class="mb-1">{{ $offer->position_title }}</h6>
                            <p class="text-muted small mb-0">{{ $offer->application->jobPosting->organization->name }}</p>
                        </div>

                        <form method="POST" action="{{ route('offer.decline.store', $offer->offer_token) }}">
                            @csrf
                            
                            <div class="mb-3">
                                <label for="reason" class="form-label">Reason for Declining (Optional)</label>
                                <textarea class="form-control" id="reason" name="reason" rows="4" 
                                          placeholder="Help us improve by sharing your reason..."></textarea>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-danger btn-lg">
                                    <i class="bi bi-x-circle"></i> Confirm Decline
                                </button>
                                <a href="{{ route('offer.view', $offer->offer_token) }}" class="btn btn-outline-secondary">
                                    Back to Offer
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
