@extends('layouts.auth')

@section('title', 'Reset Password')

@section('full-page', true)

@push('styles')
<style>
    .reset-password-image-section {
        background-image: url('{{ asset('images/landing/login.jpg') }}');
    }
</style>
@endpush

@section('content')
<div class="login-container">
    <!-- Image Section -->
    <div class="image-section reset-password-image-section">
        <div class="image-content">
            <h1>Create New <span class="highlight">Password</span></h1>
            <p>You're almost there! Enter your new password below to complete the reset process and regain access to your account.</p>
            
            <ul class="feature-list">
                <li><i class="bi bi-check-circle-fill"></i> Secure Password Reset</li>
                <li><i class="bi bi-check-circle-fill"></i> Account Protection</li>
                <li><i class="bi bi-check-circle-fill"></i> Encrypted Storage</li>
                <li><i class="bi bi-check-circle-fill"></i> Instant Access</li>
            </ul>

            <div class="footer-text">
                &copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
            </div>
        </div>
    </div>

    <!-- Form Section -->
    <div class="auth-form-section">
        <div class="auth-form">
            <div class="auth-header">
                <i class="bi bi-shield-lock"></i>
                <h2>Set New Password</h2>
                <p>Enter your new password below</p>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle me-2"></i>
                    @foreach ($errors->all() as $error)
                        {{ $error }}<br>
                    @endforeach
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <form method="POST" action="{{ route('password.update') }}">
                @csrf
                <input type="hidden" name="token" value="{{ $token }}">
                
                <div class="mb-3">
                    <label for="email" class="form-label">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-envelope"></i>
                        </span>
                        <input type="email"
                               class="form-control @error('email') is-invalid @enderror"
                               id="email"
                               name="email"
                               value="{{ $email ?? old('email') }}"
                               placeholder="Enter your email address"
                               readonly
                               required>
                    </div>
                    @error('email')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">New Password</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-lock"></i>
                        </span>
                        <input type="password"
                               class="form-control @error('password') is-invalid @enderror"
                               id="password"
                               name="password"
                               placeholder="Enter new password"
                               required>
                    </div>
                    <div class="password-strength" id="passwordStrength"></div>
                    <small class="text-muted">Password must be at least 8 characters with uppercase, lowercase, number, and special character.</small>
                    @error('password')
                        <div class="invalid-feedback">{{ $message }}</div>
                    @enderror
                </div>

                <div class="mb-4">
                    <label for="password_confirmation" class="form-label">Confirm Password</label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="bi bi-lock-fill"></i>
                        </span>
                        <input type="password"
                               class="form-control"
                               id="password_confirmation"
                               name="password_confirmation"
                               placeholder="Confirm new password"
                               required>
                    </div>
                </div>

                <button type="submit" class="btn-auth-primary">
                    <i class="bi bi-check-circle me-2"></i>Reset Password
                </button>
            </form>

            <div class="auth-footer-link">
                Remember your password? <a href="{{ route('login') }}">Back to login</a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Password strength indicator
    document.getElementById('password').addEventListener('input', function() {
        const password = this.value;
        const strengthBar = document.getElementById('passwordStrength');

        if (password.length === 0) {
            strengthBar.className = 'password-strength';
            return;
        }

        let strength = 0;
        if (password.length >= 8) strength++;
        if (password.match(/[a-z]/) && password.match(/[A-Z]/)) strength++;
        if (password.match(/[0-9]/)) strength++;
        if (password.match(/[^a-zA-Z0-9]/)) strength++;

        strengthBar.className = 'password-strength';
        if (strength <= 1) {
            strengthBar.classList.add('weak');
        } else if (strength <= 3) {
            strengthBar.classList.add('medium');
        } else {
            strengthBar.classList.add('strong');
        }
    });
</script>
@endpush