@extends('layouts.app')
@section('title', $announcement->title)
@section('page-title', 'Announcement Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Announcements', 'url' => auth()->user()->can('viewAny', App\Models\Announcement::class) ? route('announcements.index') : null],
    ['label' => Str::limit($announcement->title, 30)]
]" />

<x-alert />

<div class="row">
    <div class="col-md-8 mb-4">
        <x-info-card>
            <div class="d-flex justify-content-between align-items-start mb-4">
                <div class="flex-grow-1">
                    <div class="d-flex align-items-center mb-2">
                        @if($announcement->is_pinned)
                            <i class="bi bi-pin-fill text-danger me-2" title="Pinned"></i>
                        @endif
                        <h2 class="mb-0">{{ $announcement->title }}</h2>
                    </div>
                    <div class="d-flex gap-2 mb-3">
                        <x-status-badge :status="$announcement->status" />
                        <span class="badge bg-{{ $announcement->priority == 'urgent' ? 'danger' : ($announcement->priority == 'high' ? 'warning' : ($announcement->priority == 'medium' ? 'info' : 'secondary')) }} fs-6">
                            {{ ucfirst($announcement->priority) }} Priority
                        </span>
                        @if(!$announcement->active)
                            <span class="badge bg-danger fs-6">Inactive</span>
                        @endif
                    </div>
                </div>
                <div class="text-end">
                    @can('update', $announcement)
                    <div class="btn-group">
                        <a href="{{ route('announcements.edit', $announcement) }}" class="btn btn-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                        <button type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">
                            <span class="visually-hidden">Toggle Dropdown</span>
                        </button>
                        <ul class="dropdown-menu">
                            <li>
                                <form action="{{ route('announcements.toggle-pin', $announcement) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="dropdown-item">
                                        <i class="bi bi-pin{{ $announcement->is_pinned ? '-fill' : '' }} me-2"></i>
                                        {{ $announcement->is_pinned ? 'Unpin' : 'Pin' }}
                                    </button>
                                </form>
                            </li>
                            @if($announcement->status == 'draft')
                            <li>
                                <form action="{{ route('announcements.publish', $announcement) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="dropdown-item">
                                        <i class="bi bi-check-circle me-2"></i>Publish
                                    </button>
                                </form>
                            </li>
                            @endif
                            @if($announcement->status == 'published')
                            <li>
                                <form action="{{ route('announcements.archive', $announcement) }}" method="POST" class="d-inline">
                                    @csrf
                                    <button type="submit" class="dropdown-item">
                                        <i class="bi bi-archive me-2"></i>Archive
                                    </button>
                                </form>
                            </li>
                            @endif
                            <li><hr class="dropdown-divider"></li>
                            @can('delete', $announcement)
                            <li>
                                <form action="{{ route('announcements.destroy', $announcement) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="dropdown-item text-danger" 
                                            onclick="return confirm('Are you sure you want to delete this announcement?')">
                                        <i class="bi bi-trash me-2"></i>Delete
                                    </button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>

            @if($announcement->excerpt)
                <x-alert type="info" dismissible="false">
                    <strong>Summary:</strong> {{ $announcement->excerpt }}
                </x-alert>
            @endif

            <div class="announcement-content">
                {!! nl2br(e($announcement->content)) !!}
            </div>

            <hr class="my-4">

            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Publication Details</h6>
                    <table class="table table-sm">
                        <x-detail-row label="Created By" :value="$announcement->creator->name ?? 'N/A'" />
                        <x-detail-row label="Created On" :value="$announcement->created_at->format('l, F d, Y \a\t g:i A')" />
                        @if($announcement->updated_at != $announcement->created_at)
                        <x-detail-row label="Last Updated" :value="$announcement->updated_at->format('l, F d, Y \a\t g:i A')" />
                        @endif
                    </table>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Visibility Period</h6>
                    <table class="table table-sm">
                        <x-detail-row label="Start Date" :value="$announcement->start_date->format('l, F d, Y')" />
                        <x-detail-row label="End Date" :value="$announcement->end_date ? $announcement->end_date->format('l, F d, Y') : 'No expiration'" />
                        <x-detail-row label="Status">
                            @if($announcement->canBeViewed())
                                <span class="badge bg-success">Visible to Users</span>
                            @else
                                <span class="badge bg-warning">Not Visible</span>
                            @endif
                        </x-detail-row>
                    </table>
                </div>
            </div>
        </x-info-card>
    </div>

    <div class="col-md-4 mb-4">
        <x-info-card class="text-center mb-3">
            <div class="mb-3">
                <i class="bi bi-megaphone" style="font-size: 48px; color: #007bff;"></i>
            </div>
            <h5>Announcement</h5>
            <p class="text-muted mb-3">{{ ucfirst($announcement->priority) }} Priority</p>
            
            <div class="d-grid gap-2">
                @can('viewAny', App\Models\Announcement::class)
                <a href="{{ route('announcements.index') }}" class="btn btn-outline-primary">
                    <i class="bi bi-list"></i> All Announcements
                </a>
                @endcan
                @can('create', App\Models\Announcement::class)
                <a href="{{ route('announcements.create') }}" class="btn btn-outline-success">
                    <i class="bi bi-plus-circle"></i> Create New
                </a>
                @endcan
            </div>
        </x-info-card>

        @if($announcement->canBeViewed())
        <x-info-card title="Visibility Status" icon="eye">
            <x-alert type="success" dismissible="false">
                This announcement is currently visible to users.
            </x-alert>
        </x-info-card>
        @else
        <x-info-card title="Visibility Status" icon="eye-slash">
            <x-alert type="warning" dismissible="false">
                This announcement is not visible to users because:
                <ul class="mt-2 mb-0">
                    @if(!$announcement->isPublished())
                        <li>Status is not "Published"</li>
                    @endif
                    @if(!$announcement->active)
                        <li>Announcement is inactive</li>
                    @endif
                    @if($announcement->start_date > now())
                        <li>Start date is in the future</li>
                    @endif
                    @if($announcement->end_date && $announcement->end_date < now())
                        <li>End date has passed</li>
                    @endif
                </ul>
            </x-alert>
        </x-info-card>
        @endif
    </div>
</div>
@push('styles')
<style>
.announcement-content {
    font-size: 1.1rem;
    line-height: 1.6;
    color: #333;
}
</style>
@endpush
@endsection
