@extends('layouts.app')

@section('title', 'Edit Announcement')
@section('page-title', 'Edit Announcement')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Announcements', 'url' => auth()->user()->can('viewAny', App\Models\Announcement::class) ? route('announcements.index') : null],
        ['label' => Str::limit($announcement->title, 20), 'url' => auth()->user()->can('view', $announcement) ? route('announcements.show', $announcement) : null],
        ['label' => 'Edit']
    ]" />

    <div class="row">
        <div class="col-md-8">
            <div class="table-card">
                <div class="mb-4">
                    <h4>Edit Announcement</h4>
                    <p class="text-muted">Update announcement details and settings</p>
                </div>

                <form action="{{ route('announcements.update', $announcement) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-12">
                            <x-form.input name="title" label="Title" required :value="$announcement->title" />
                        </div>

                        <div class="col-md-12">
                            <x-form.textarea 
                                name="excerpt" 
                                label="Excerpt"
                                rows="2"
                                :value="$announcement->excerpt"
                                placeholder="Brief summary of the announcement (optional)"
                                help="If left empty, an excerpt will be automatically generated from the content." />
                        </div>

                        <div class="col-md-12">
                            <x-form.textarea 
                                name="content" 
                                label="Content" 
                                required
                                rows="8"
                                :value="$announcement->content" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="priority" 
                                label="Priority" 
                                required
                                :value="$announcement->priority"
                                :options="[
                                    'low' => 'Low',
                                    'medium' => 'Medium',
                                    'high' => 'High',
                                    'urgent' => 'Urgent'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="status" 
                                label="Status" 
                                required
                                :value="$announcement->status"
                                :options="[
                                    'draft' => 'Draft',
                                    'published' => 'Published',
                                    'archived' => 'Archived'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="date" 
                                name="start_date" 
                                label="Start Date" 
                                required
                                :value="$announcement->start_date->format('Y-m-d')" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="date" 
                                name="end_date" 
                                label="End Date"
                                :value="$announcement->end_date?->format('Y-m-d')"
                                help="Leave empty for no expiration date" />
                        </div>

                        <div class="col-md-12">
                            <x-form.checkbox 
                                name="is_pinned" 
                                label="Pin this announcement"
                                :checked="$announcement->is_pinned"
                                help="Pinned announcements appear at the top of the list" />
                        </div>

                        <div class="col-md-12">
                            <x-form.checkbox 
                                name="active" 
                                label="Active"
                                :checked="$announcement->active"
                                help="Only active announcements are visible to users" />
                        </div>
                    </div>

                    <x-form.button-group 
                        :cancelUrl="auth()->user()->can('view', $announcement) ? route('announcements.show', $announcement) : route('announcements.index')"
                        submitText="Update Announcement"
                        submitIcon="bi-check-circle" />
                </form>
            </div>
        </div>

        <div class="col-md-4">
            <div class="table-card">
                <h6 class="mb-3"><i class="bi bi-info-circle me-2"></i>Current Status</h6>
                <div class="mb-3">
                    <strong>Status:</strong> 
                    <x-status-badge :status="$announcement->status" />
                </div>
                <div class="mb-3">
                    <strong>Priority:</strong> 
                    <span class="badge bg-{{ $announcement->priority == 'urgent' ? 'danger' : ($announcement->priority == 'high' ? 'warning' : ($announcement->priority == 'medium' ? 'info' : 'secondary')) }}">
                        {{ ucfirst($announcement->priority) }}
                    </span>
                </div>
                <div class="mb-3">
                    <strong>Visibility:</strong> 
                    @if($announcement->canBeViewed())
                        <span class="badge bg-success">Visible</span>
                    @else
                        <span class="badge bg-warning">Not Visible</span>
                    @endif
                </div>
                <div class="mb-3">
                    <strong>Created:</strong> {{ $announcement->created_at->format('M d, Y') }}
                </div>
                <div class="mb-3">
                    <strong>Last Updated:</strong> {{ $announcement->updated_at->format('M d, Y') }}
                </div>
            </div>

            <div class="table-card mt-3">
                <h6 class="mb-3"><i class="bi bi-lightbulb me-2"></i>Tips</h6>
                <div class="list-group list-group-flush">
                    <div class="list-group-item px-0">
                        <small><strong>Draft:</strong> Use for announcements that are not ready to be published</small>
                    </div>
                    <div class="list-group-item px-0">
                        <small><strong>Published:</strong> Makes the announcement visible to users within the date range</small>
                    </div>
                    <div class="list-group-item px-0">
                        <small><strong>Archived:</strong> Hides the announcement from users but keeps it for reference</small>
                    </div>
                    <div class="list-group-item px-0">
                        <small><strong>Pinned:</strong> Shows the announcement at the top of lists</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
