@extends('layouts.app')

@section('title', 'Create Announcement')
@section('page-title', 'Create Announcement')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Announcements', 'url' => auth()->user()->can('viewAny', App\Models\Announcement::class) ? route('announcements.index') : null],
        ['label' => 'Create']
    ]" />

    <div class="row">
        <div class="col-md-8">
            <div class="table-card">
                <div class="mb-4">
                    <h4>Create New Announcement</h4>
                    <p class="text-muted">Create and publish announcements for your organization</p>
                </div>

                <form action="{{ route('announcements.store') }}" method="POST">
                    @csrf

                    <x-form.input 
                        name="title" 
                        label="Title" 
                        required 
                        placeholder="Enter announcement title" />

                    <x-form.textarea 
                        name="excerpt" 
                        label="Excerpt" 
                        rows="2"
                        placeholder="Brief summary of the announcement (optional)"
                        help="If left empty, an excerpt will be automatically generated from the content." />

                    <x-form.textarea 
                        name="content" 
                        label="Content" 
                        rows="8"
                        required />

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.select 
                                name="priority" 
                                label="Priority" 
                                required
                                :value="old('priority', 'medium')"
                                :options="[
                                    'low' => 'Low',
                                    'medium' => 'Medium',
                                    'high' => 'High',
                                    'urgent' => 'Urgent'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="status" 
                                label="Status" 
                                required
                                :value="old('status', 'draft')"
                                :options="[
                                    'draft' => 'Draft',
                                    'published' => 'Published'
                                ]" />
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.date 
                                name="start_date" 
                                label="Start Date" 
                                required
                                :value="old('start_date', now()->format('Y-m-d'))" />
                        </div>

                        <div class="col-md-6">
                            <x-form.date 
                                name="end_date" 
                                label="End Date"
                                help="Leave empty for no expiration date" />
                        </div>
                    </div>

                    <x-form.checkbox 
                        name="is_pinned" 
                        label="Pin this announcement"
                        help="Pinned announcements appear at the top of the list" />

                    <x-form.checkbox 
                        name="active" 
                        label="Active"
                        :checked="old('active', true)"
                        help="Only active announcements are visible to users" />

                    <x-form.actions 
                        submit-text="Create Announcement"
                        :cancel-url="auth()->user()->can('viewAny', App\Models\Announcement::class) ? route('announcements.index') : route('dashboard')" />
                </form>
            </div>
        </div>

        <div class="col-md-4">
            <div class="table-card">
                <h6 class="mb-3"><i class="bi bi-info-circle me-2"></i>Announcement Guidelines</h6>
                <div class="list-group list-group-flush">
                    <div class="list-group-item px-0">
                        <strong>Title:</strong> Keep it clear and concise
                    </div>
                    <div class="list-group-item px-0">
                        <strong>Priority Levels:</strong>
                        <ul class="mt-2 mb-0">
                            <li><span class="badge bg-secondary">Low</span> - General information</li>
                            <li><span class="badge bg-info">Medium</span> - Important updates</li>
                            <li><span class="badge bg-warning">High</span> - Critical information</li>
                            <li><span class="badge bg-danger">Urgent</span> - Immediate attention required</li>
                        </ul>
                    </div>
                    <div class="list-group-item px-0">
                        <strong>Status:</strong>
                        <ul class="mt-2 mb-0">
                            <li><span class="badge bg-warning">Draft</span> - Not visible to users</li>
                            <li><span class="badge bg-success">Published</span> - Visible to users</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection