# Troubleshooting Guide

## Overview

This guide provides solutions to common issues encountered while using Qaya HRM system.

---

## General Issues

### Cannot Login

**Symptoms**:
- Login page shows but credentials don't work
- "Invalid credentials" error
- Redirected back to login page

**Solutions**:

1. **Verify Credentials**
   ```
   - Check email address is correct
   - Verify password (case-sensitive)
   - Try password reset if forgotten
   ```

2. **Check Account Status**
   ```
   - Account may be inactive
   - Account may be locked
   - Contact administrator
   ```

3. **Clear Browser Cache**
   ```
   - Clear cookies and cache
   - Try incognito/private mode
   - Try different browser
   ```

4. **Check Organization**
   ```
   - Verify using correct login URL
   - SystemAdmin: /systemadmin/login
   - Organization users: /login
   ```

---

### 419 Page Expired Error

**Symptoms**:
- "419 | Page Expired" when submitting forms
- CSRF token mismatch error

**Solutions**:

1. **Clear Application Cache**
   ```bash
   php artisan cache:clear
   php artisan config:clear
   php artisan view:clear
   ```

2. **Check Session Configuration**
   ```env
   # In .env file
   SESSION_DRIVER=database
   SESSION_LIFETIME=120
   ```

3. **Clear Browser Cache**
   ```
   - Clear cookies
   - Refresh page (Ctrl+F5)
   - Try incognito mode
   ```

---

### 500 Internal Server Error

**Symptoms**:
- White page with "500 Internal Server Error"
- Application not loading

**Solutions**:

1. **Check Error Logs**
   ```bash
   # Laravel log
   tail -f storage/logs/laravel.log
   
   # Web server log
   tail -f /var/log/nginx/error.log
   # or
   tail -f /var/log/apache2/error.log
   ```

2. **Check File Permissions**
   ```bash
   sudo chown -R www-data:www-data storage bootstrap/cache
   sudo chmod -R 775 storage bootstrap/cache
   ```

3. **Check Environment File**
   ```bash
   # Verify .env exists
   ls -la .env
   
   # Check APP_KEY is set
   grep APP_KEY .env
   
   # Generate if missing
   php artisan key:generate
   ```

4. **Check PHP Version**
   ```bash
   php -v
   # Should be 8.2 or higher
   ```

---

### 404 Not Found

**Symptoms**:
- Page not found errors
- Routes not working

**Solutions**:

1. **Clear Route Cache**
   ```bash
   php artisan route:clear
   php artisan route:cache
   ```

2. **Check Web Server Configuration**
   ```nginx
   # Nginx - ensure try_files is correct
   location / {
       try_files $uri $uri/ /index.php?$query_string;
   }
   ```

3. **Check .htaccess** (Apache)
   ```apache
   # Ensure mod_rewrite is enabled
   sudo a2enmod rewrite
   sudo systemctl restart apache2
   ```

---

## Employee Management Issues

### Cannot Create Employee

**Symptoms**:
- Form validation errors
- Employee not saving

**Solutions**:

1. **Check Required Fields**
   ```
   Required fields:
   - First Name
   - Last Name
   - Email (must be unique)
   - Department
   - Position
   - Joining Date
   - Status
   ```

2. **Check Email Uniqueness**
   ```
   - Email must be unique within organization
   - Check if email already exists
   - Use different email address
   ```

3. **Check Permissions**
   ```
   - Verify you have 'create_employees' permission
   - Check your role assignments
   - Contact administrator
   ```

---

### Employee Import Fails

**Symptoms**:
- Import validation errors
- File not processing

**Solutions**:

1. **Check File Format**
   ```
   - Use provided template
   - Ensure correct column headers
   - Save as CSV or XLSX
   - Check file encoding (UTF-8)
   ```

2. **Validate Data**
   ```
   - Check for duplicate emails
   - Verify department names exist
   - Verify position names exist
   - Check date formats (YYYY-MM-DD)
   ```

3. **Check File Size**
   ```
   - Maximum file size: 10MB
   - Split large files
   - Import in batches
   ```

---

## Attendance Issues

### Cannot Check In

**Symptoms**:
- Check-in button not working
- "Outside check-in window" error

**Solutions**:

1. **Check Time Window**
   ```
   - Verify current time is within check-in window
   - Default: 6:00 AM - 12:00 PM
   - Contact HR to adjust settings
   ```

2. **Check Previous Check-in**
   ```
   - Cannot check in twice same day
   - Check if already checked in
   - Contact HR if error
   ```

3. **Check Employee Status**
   ```
   - Must be active employee
   - Check employment status
   - Contact HR
   ```

---

### Attendance Not Showing

**Symptoms**:
- Attendance records missing
- Calendar not displaying data

**Solutions**:

1. **Check Date Range**
   ```
   - Verify selected date range
   - Check filters applied
   - Clear filters and try again
   ```

2. **Check Permissions**
   ```
   - Verify attendance view permissions
   - Check organization scope
   - Contact administrator
   ```

3. **Refresh Data**
   ```
   - Clear browser cache
   - Refresh page (F5)
   - Try different browser
   ```

---

## Leave Management Issues

### Cannot Apply for Leave

**Symptoms**:
- Leave application form not submitting
- Insufficient balance error

**Solutions**:

1. **Check Leave Balance**
   ```
   - Verify sufficient balance
   - Check leave type
   - View balance summary
   ```

2. **Check Date Selection**
   ```
   - Start date must be before end date
   - Cannot select past dates
   - Check for overlapping leaves
   ```

3. **Check Leave Type Settings**
   ```
   - Verify leave type is active
   - Check minimum notice period
   - Check maximum consecutive days
   ```

---

### Leave Not Approved

**Symptoms**:
- Leave stuck in pending status
- Manager not receiving notification

**Solutions**:

1. **Check Approval Workflow**
   ```
   - Verify manager assignment
   - Check manager has approval permission
   - Contact manager directly
   ```

2. **Check Email Notifications**
   ```
   - Verify email settings
   - Check spam folder
   - Test email configuration
   ```

3. **Manual Follow-up**
   ```
   - Contact manager directly
   - Check with HR
   - Verify leave request details
   ```

---

## Payroll Issues

### Payroll Calculation Incorrect

**Symptoms**:
- Wrong salary amount
- Incorrect deductions
- Tax calculation errors

**Solutions**:

1. **Verify Employee Data**
   ```
   - Check basic salary
   - Verify allowances
   - Check deductions
   - Verify tax information (KRA PIN, NHIF, NSSF)
   ```

2. **Check Payroll Settings**
   ```
   - Verify tax bands
   - Check NHIF rates
   - Check NSSF rates
   - Verify housing levy rate
   ```

3. **Check Attendance Data**
   ```
   - Verify attendance records
   - Check for absences
   - Verify worked days
   ```

4. **Check Loan Deductions**
   ```
   - Verify active loans
   - Check repayment amounts
   - Verify loan status
   ```

---

### Cannot Generate Payroll

**Symptoms**:
- Bulk payroll generation fails
- Error messages during generation

**Solutions**:

1. **Check Employee Eligibility**
   ```
   - Employees must be active
   - Must have basic salary set
   - Must have complete tax information
   ```

2. **Check for Duplicates**
   ```
   - Cannot generate payroll twice for same month
   - Check existing payroll records
   - Delete draft payroll if needed
   ```

3. **Check Permissions**
   ```
   - Verify 'manage_payroll' permission
   - Check role assignment
   - Contact administrator
   ```

---

## Performance Issues

### Application Running Slow

**Symptoms**:
- Pages loading slowly
- Timeouts
- Unresponsive interface

**Solutions**:

1. **Clear Cache**
   ```bash
   php artisan cache:clear
   php artisan config:clear
   php artisan route:clear
   php artisan view:clear
   ```

2. **Optimize Application**
   ```bash
   php artisan optimize
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

3. **Check Server Resources**
   ```bash
   # Check CPU usage
   top
   
   # Check memory
   free -h
   
   # Check disk space
   df -h
   ```

4. **Check Database**
   ```bash
   # Check slow queries
   # Enable slow query log in MySQL
   
   # Optimize tables
   php artisan db:optimize
   ```

---

### Queue Not Processing

**Symptoms**:
- Jobs stuck in queue
- Emails not sending
- Reports not generating

**Solutions**:

1. **Check Queue Worker**
   ```bash
   # Check supervisor status
   sudo supervisorctl status
   
   # Restart workers
   sudo supervisorctl restart qaya-hrm-worker:*
   ```

2. **Check Failed Jobs**
   ```bash
   # View failed jobs
   php artisan queue:failed
   
   # Retry failed jobs
   php artisan queue:retry all
   ```

3. **Check Queue Configuration**
   ```env
   # In .env
   QUEUE_CONNECTION=database
   # or
   QUEUE_CONNECTION=redis
   ```

---

## Email Issues

### Emails Not Sending

**Symptoms**:
- Notifications not received
- Password reset emails not arriving
- System emails failing

**Solutions**:

1. **Check Email Configuration**
   ```env
   # In .env file
   MAIL_MAILER=smtp
   MAIL_HOST=smtp.gmail.com
   MAIL_PORT=587
   MAIL_USERNAME=your-email@gmail.com
   MAIL_PASSWORD=your-app-password
   MAIL_ENCRYPTION=tls
   ```

2. **Test Email**
   ```bash
   php artisan tinker
   Mail::raw('Test email', function($msg) {
       $msg->to('test@example.com')->subject('Test');
   });
   ```

3. **Check Spam Folder**
   ```
   - Check recipient's spam folder
   - Whitelist sender email
   - Check email filters
   ```

4. **Check Queue**
   ```bash
   # If using queue for emails
   php artisan queue:work
   ```

---

## File Upload Issues

### Cannot Upload Files

**Symptoms**:
- File upload fails
- "File too large" error
- Upload button not working

**Solutions**:

1. **Check File Size**
   ```
   - Maximum file size: 2MB (photos), 10MB (documents)
   - Compress large files
   - Use appropriate file format
   ```

2. **Check File Type**
   ```
   Allowed types:
   - Images: JPG, PNG, GIF
   - Documents: PDF, DOC, DOCX
   - Spreadsheets: XLS, XLSX, CSV
   ```

3. **Check PHP Configuration**
   ```ini
   # In php.ini
   upload_max_filesize = 20M
   post_max_size = 20M
   max_execution_time = 300
   ```

4. **Check Storage Permissions**
   ```bash
   sudo chmod -R 775 storage
   sudo chown -R www-data:www-data storage
   ```

---

## Database Issues

### Database Connection Failed

**Symptoms**:
- "SQLSTATE[HY000] [2002] Connection refused"
- Cannot connect to database

**Solutions**:

1. **Check Database Service**
   ```bash
   # Check if MySQL is running
   sudo systemctl status mysql
   
   # Start if stopped
   sudo systemctl start mysql
   ```

2. **Check Database Credentials**
   ```env
   # In .env file
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=qaya_hrm
   DB_USERNAME=qaya_user
   DB_PASSWORD=your_password
   ```

3. **Test Connection**
   ```bash
   mysql -u qaya_user -p qaya_hrm
   ```

4. **Check Firewall**
   ```bash
   # Allow MySQL port
   sudo ufw allow 3306/tcp
   ```

---

## Security Issues

### Account Locked

**Symptoms**:
- "Account locked" message
- Cannot login after multiple attempts

**Solutions**:

1. **Wait for Auto-Unlock**
   ```
   - Default lockout: 30 minutes
   - Wait and try again
   ```

2. **Contact Administrator**
   ```
   - Request manual unlock
   - Verify identity
   - Reset password if needed
   ```

3. **Check Security Logs**
   ```
   - Review failed login attempts
   - Check for suspicious activity
   - Update password
   ```

---

### 2FA Not Working

**Symptoms**:
- 2FA code not accepted
- "Invalid code" error

**Solutions**:

1. **Check Time Sync**
   ```
   - Ensure device time is correct
   - Sync with network time
   - Time-based codes expire quickly
   ```

2. **Use Recovery Code**
   ```
   - Use one of the recovery codes
   - Each code works once
   - Generate new codes after use
   ```

3. **Reset 2FA**
   ```
   - Contact administrator
   - Request 2FA reset
   - Re-setup 2FA
   ```

---

## Browser-Specific Issues

### Chrome Issues

**Solutions**:
```
- Clear cache and cookies
- Disable extensions
- Update Chrome
- Try incognito mode
```

### Firefox Issues

**Solutions**:
```
- Clear cache and cookies
- Disable add-ons
- Update Firefox
- Try private window
```

### Safari Issues

**Solutions**:
```
- Clear cache
- Check privacy settings
- Update Safari
- Try private browsing
```

---

## Mobile Issues

### Mobile View Not Working

**Symptoms**:
- Layout broken on mobile
- Features not accessible

**Solutions**:

1. **Check Responsive Design**
   ```
   - Rotate device
   - Zoom out
   - Try landscape mode
   ```

2. **Use Desktop Site**
   ```
   - Request desktop site in browser
   - Use tablet mode
   - Access from computer
   ```

3. **Update Browser**
   ```
   - Update mobile browser
   - Try different browser
   - Clear browser cache
   ```

---

## Getting Help

### Before Contacting Support

**Gather Information**:
```
1. What were you trying to do?
2. What happened instead?
3. Error messages (screenshot)
4. Browser and version
5. Steps to reproduce
6. When did it start?
```

### Contact Channels

**Internal Support**:
```
- IT Help Desk
- HR Department
- System Administrator
- Email: support@yourcompany.com
```

**Documentation**:
```
- Check this troubleshooting guide
- Review module documentation
- Check FAQ
- Search knowledge base
```

---

## Diagnostic Commands

### System Health Check

```bash
# Check application status
php artisan about

# Check database connection
php artisan db:show

# Check queue status
php artisan queue:monitor

# Check cache status
php artisan cache:table

# Check storage link
ls -la public/storage
```

### Clear Everything

```bash
# Nuclear option - clear all caches
php artisan optimize:clear
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear
composer dump-autoload
```

---

## Prevention Tips

### Regular Maintenance

1. **Keep Software Updated**
   - Update application regularly
   - Update dependencies
   - Apply security patches

2. **Monitor System**
   - Check logs regularly
   - Monitor performance
   - Review error reports

3. **Backup Regularly**
   - Daily database backups
   - Weekly full backups
   - Test restore procedures

4. **Train Users**
   - Provide user training
   - Share documentation
   - Communicate updates

---

**Last Updated**: February 2026
