# System Settings Module

## Overview

The System Settings module provides centralized configuration for all system parameters, organization settings, and module-specific configurations.

---

## Features

### Core Functionality
- ✅ Organization profile management
- ✅ Attendance settings configuration
- ✅ Leave types management
- ✅ Position management
- ✅ Holiday calendar
- ✅ Payroll settings
- ✅ Email configuration
- ✅ Notification settings
- ✅ Security settings
- ✅ System preferences
- ✅ Integration settings

---

## Settings Categories

### 1. Organization Settings

**Access**: Settings → Organization

**Configurable Fields**:

**Company Information**:
```
- Company Name *
- Legal Name
- Registration Number
- Tax ID (KRA PIN)
- Industry
- Company Size
- Founded Date
```

**Contact Information**:
```
- Primary Email *
- Phone Number *
- Fax Number
- Website
- LinkedIn
- Twitter
```

**Address**:
```
- Street Address *
- City *
- State/Province
- ZIP/Postal Code *
- Country *
```

**Branding**:
```
- Company Logo (Upload)
- Primary Color
- Secondary Color
- Favicon
- Email Header Image
```

**Business Hours**:
```
- Work Days: [Mon] [Tue] [Wed] [Thu] [Fri] [Sat] [Sun]
- Start Time: [09:00]
- End Time: [17:00]
- Timezone: [Africa/Nairobi]
```

---

### 2. Attendance Settings

**Access**: Settings → Attendance

**Time Windows**:
```
Check-in Window:
- Earliest Check-in: [06:00] AM
- Latest Check-in: [12:00] PM

Check-out Window:
- Earliest Check-out: [03:00] PM
- Latest Check-out: [11:59] PM

Official Work Hours:
- Work Start: [09:00] AM
- Work End: [05:00] PM
```

**Thresholds**:
```
- Late Arrival Threshold: [15] minutes
- Early Leave Threshold: [15] minutes
- Half Day Hours: [4] hours
- Full Day Hours: [8] hours
- Grace Period: [5] minutes
```

**Options**:
```
☑ Allow Weekend Check-in
☑ Require Check-out
☑ Auto Check-out at End of Day
☑ Track IP Address
☑ Allow Mobile Check-in
☐ Require Location (GPS)
```

**Notifications**:
```
☑ Notify on Late Arrival
☑ Notify on Missed Check-out
☑ Send Daily Summary to Manager
☑ Send Monthly Report to HR
```

---

### 3. Leave Types Management

**Access**: Settings → Leave Types

**Leave Type Configuration**:

**Basic Settings**:
```
- Leave Type Name *
- Short Code
- Color Code (for calendar)
- Icon
- Active Status
- Display Order
```

**Allocation**:
```
- Annual Days *
- Accrual Method:
  ○ Annual (all at once)
  ○ Monthly (pro-rated)
  ○ Per Pay Period
- Minimum Service Period: [0] months
- Pro-rata for New Joiners: [✓]
```

**Rules**:
```
- Requires Approval: [✓]
- Approver Level:
  ○ Direct Manager
  ○ HR Manager
  ○ Both
- Minimum Notice Days: [2]
- Maximum Consecutive Days: [21]
- Allow Half Days: [✓]
- Allow Negative Balance: [✗]
- Requires Documentation: [✗]
```

**Carry Forward**:
```
- Enable Carry Forward: [✓]
- Maximum Days to Carry: [5]
- Expiry Period: [3] months
- Auto-calculation: [✓]
```

**Payroll Impact**:
```
- Leave Type:
  ○ Paid
  ○ Unpaid
- Affect Salary: [✓]
- Deduction Method:
  ○ Full Day
  ○ Pro-rated
```

**Default Leave Types**:
- Annual Leave (21 days, paid)
- Sick Leave (14 days, paid)
- Casual Leave (5 days, paid)
- Maternity Leave (90 days, paid)
- Paternity Leave (14 days, paid)
- Unpaid Leave (unlimited, unpaid)
- Compassionate Leave (5 days, paid)

---

### 4. Position Management

**Access**: Settings → Positions

**Position Configuration**:
```
- Position Name *
- Department
- Position Code
- Job Level:
  ○ Entry Level
  ○ Junior
  ○ Mid-Level
  ○ Senior
  ○ Lead
  ○ Manager
  ○ Director
  ○ Executive
- Description
- Requirements
- Expected Employees
- Active Status
```

**Salary Range** (Optional):
```
- Minimum Salary
- Maximum Salary
- Currency
```

**Skills Required**:
```
[Add Skills]
- Skill Name
- Proficiency Level
- Mandatory/Optional
```

---

### 5. Holiday Calendar

**Access**: Settings → Holidays

**Holiday Configuration**:
```
- Holiday Name *
- Date *
- Type:
  ○ Public Holiday
  ○ Company Holiday
  ○ Optional Holiday
- Recurring:
  ○ One-time
  ○ Annual
- Description
- Applies to:
  ○ All Employees
  ○ Specific Departments
  ○ Specific Locations
```

**Kenya Public Holidays** (Default):
```
- New Year's Day (Jan 1)
- Good Friday (Variable)
- Easter Monday (Variable)
- Labour Day (May 1)
- Madaraka Day (June 1)
- Eid ul-Fitr (Variable)
- Eid ul-Adha (Variable)
- Mashujaa Day (Oct 20)
- Jamhuri Day (Dec 12)
- Christmas Day (Dec 25)
- Boxing Day (Dec 26)
```

**Bulk Import**:
```
[Upload CSV]
Format: Name, Date, Type, Description
```

---

### 6. Payroll Settings

**Access**: Settings → Payroll Settings

**Tax Configuration**:
```
PAYE Tax Bands:
Band 1: [0] - [24,000] @ [10]%
Band 2: [24,001] - [32,333] @ [25]%
Band 3: [32,334] - [500,000] @ [30]%
Band 4: [500,001] - [800,000] @ [32.5]%
Band 5: [800,001+] @ [35]%

Personal Relief: [2,400] per month
```

**NHIF Rates**:
```
[Configure NHIF Bands]
Gross Salary Range → Contribution Amount
```

**NSSF Rates**:
```
Tier I: [7,000] @ [6]%
Tier II: [36,000] @ [6]%
```

**Housing Levy**:
```
Rate: [1.5]%
Enabled: [✓]
```

**Payroll Options**:
```
- Default Pay Day: [25] of month
- Currency: [KES]
- Decimal Places: [2]
- Rounding Method:
  ○ Round Up
  ○ Round Down
  ○ Round to Nearest
```

**Allowances**:
```
[Add Allowance Type]
- Name
- Taxable: Yes/No
- Default Amount
- Calculation Method
```

**Deductions**:
```
[Add Deduction Type]
- Name
- Calculation Method
- Maximum Amount
- Priority Order
```

---

### 7. Email Configuration

**Access**: Settings → Email

**SMTP Settings**:
```
- Mail Driver: [smtp]
- Host: [smtp.gmail.com]
- Port: [587]
- Encryption: [TLS]
- Username: [____________]
- Password: [____________]
- From Address: [noreply@company.com]
- From Name: [Company Name]
```

**Email Templates**:
```
Available Templates:
- Welcome Email
- Leave Approval
- Leave Rejection
- Payslip Notification
- Password Reset
- Interview Invitation
- Offer Letter
- Performance Review Reminder

[Edit Template] [Preview] [Test Send]
```

**Email Notifications**:
```
☑ Leave Requests
☑ Leave Approvals
☑ Payroll Generated
☑ Attendance Alerts
☑ Performance Reviews
☑ Training Enrollments
☑ System Announcements
```

---

### 8. Notification Settings

**Access**: Settings → Notifications

**Notification Channels**:
```
☑ Email
☑ In-App Notifications
☐ SMS (Coming Soon)
☐ Push Notifications (Coming Soon)
```

**Notification Preferences by Type**:
```
Leave Management:
☑ New leave request (Managers)
☑ Leave approved (Employees)
☑ Leave rejected (Employees)
☑ Leave balance low (Employees)

Attendance:
☑ Late arrival (Managers)
☑ Missed check-out (Employees)
☑ Monthly summary (Managers)

Payroll:
☑ Payslip ready (Employees)
☑ Payroll approved (HR)
☑ Payment processed (Finance)

Performance:
☑ Review due (Employees & Managers)
☑ Goal deadline approaching (Employees)
☑ Feedback received (Employees)

Training:
☑ Enrollment confirmed (Employees)
☑ Training reminder (Employees)
☑ Certificate issued (Employees)
```

---

### 9. Security Settings

**Access**: Settings → Security

**Password Policy**:
```
☑ Minimum length: [8] characters
☑ Require uppercase
☑ Require lowercase
☑ Require numbers
☑ Require special characters
☑ Prevent common passwords
☑ Password history: [5] passwords
☑ Password expiry: [90] days
```

**Account Lockout**:
```
☑ Enable account lockout
- Failed attempts: [5]
- Lockout duration: [30] minutes
- Reset after: [24] hours
```

**Session Management**:
```
- Session timeout: [120] minutes
- Remember me duration: [30] days
- Max concurrent sessions: [3]
☑ Force logout on password change
```

**Two-Factor Authentication**:
```
☑ Enable 2FA
- Enforcement:
  ○ Optional
  ○ Required for Admins
  ○ Required for All Users
- Recovery codes: [10]
```

**IP Whitelisting**:
```
☑ Enable IP whitelisting
[Manage IP Whitelist]
```

---

### 10. System Preferences

**Access**: Settings → System

**General**:
```
- System Name: [Qaya HRM]
- System URL: [https://hrm.company.com]
- Default Language: [English]
- Date Format: [YYYY-MM-DD]
- Time Format: [24-hour]
- First Day of Week: [Monday]
```

**Regional**:
```
- Country: [Kenya]
- Currency: [KES]
- Timezone: [Africa/Nairobi]
- Number Format: [1,234.56]
```

**Features**:
```
☑ Enable Attendance Module
☑ Enable Leave Module
☑ Enable Payroll Module
☑ Enable Performance Module
☑ Enable Training Module
☑ Enable Recruitment Module
☐ Enable Projects Module (Coming Soon)
☐ Enable Assets Module (Coming Soon)
```

**Maintenance**:
```
☐ Maintenance Mode
- Maintenance Message: [____________]
- Allowed IPs: [____________]
```

---

### 11. Integration Settings

**Access**: Settings → Integrations

**Available Integrations**:

**Email Services**:
```
- Gmail
- Outlook
- SendGrid
- Mailgun
```

**Calendar**:
```
- Google Calendar
- Outlook Calendar
- iCal
```

**Storage**:
```
- Local Storage
- Amazon S3
- Google Drive
- Dropbox
```

**Payment Gateways** (Future):
```
- M-Pesa
- PayPal
- Stripe
- Bank Integration
```

**HR Systems** (Future):
```
- Biometric Devices
- Access Control Systems
- Time Clocks
```

---

## Settings Management

### Import/Export Settings

**Export Settings**:
```
[Export All Settings]
Format: JSON
Includes:
- Organization settings
- Module configurations
- User preferences
- System settings

[Download Configuration]
```

**Import Settings**:
```
[Upload Configuration File]
- Validate before import
- Preview changes
- Selective import
- Backup current settings

[Import Settings]
```

### Settings Backup

**Automatic Backups**:
```
☑ Enable automatic backups
- Frequency: [Daily]
- Retention: [30] days
- Storage: [Local/Cloud]
```

**Manual Backup**:
```
[Create Backup Now]
- Include database
- Include files
- Include settings
- Compress backup

[Download Backup]
```

---

## Permissions

### Required Permissions

| Action | Permission | Description |
|--------|-----------|-------------|
| View Settings | `view_settings` | Access settings pages |
| Edit Organization | `edit_organization` | Modify organization settings |
| Manage Attendance Settings | `manage_attendance_settings` | Configure attendance |
| Manage Leave Types | `manage_leave_types` | Configure leave types |
| Manage Positions | `manage_positions` | Configure positions |
| Manage Holidays | `manage_holidays` | Configure holidays |
| Manage Payroll Settings | `manage_payroll_settings` | Configure payroll |
| Manage Email Settings | `manage_email_settings` | Configure email |
| Manage Security Settings | `manage_security_settings` | Configure security |
| Manage System Settings | `manage_system_settings` | Configure system |

---

## Best Practices

### For System Administrators

1. **Regular Review**
   - Review settings quarterly
   - Update as needed
   - Document changes
   - Test after changes

2. **Security**
   - Use strong security settings
   - Regular security audits
   - Keep software updated
   - Monitor access logs

3. **Backup**
   - Regular backups
   - Test restore process
   - Off-site storage
   - Document procedures

4. **Documentation**
   - Document all settings
   - Maintain change log
   - Create runbooks
   - Train staff

### For Organization Admins

1. **Configuration**
   - Configure all modules
   - Set appropriate defaults
   - Test workflows
   - Train users

2. **Maintenance**
   - Keep information current
   - Review periodically
   - Update as needed
   - Monitor usage

3. **Compliance**
   - Follow regulations
   - Maintain records
   - Regular audits
   - Update policies

---

## Troubleshooting

### Common Issues

**Issue**: Settings not saving
- **Solution**: Check permissions, verify form validation, check logs

**Issue**: Email not sending
- **Solution**: Verify SMTP settings, test connection, check firewall

**Issue**: Changes not reflecting
- **Solution**: Clear cache, refresh page, check browser cache

**Issue**: Cannot access settings
- **Solution**: Verify permissions, check user role, contact admin

---

## Future Enhancements

- [ ] Settings versioning
- [ ] Settings templates
- [ ] Multi-language support
- [ ] Advanced customization
- [ ] API for settings management
- [ ] Settings migration tools
- [ ] Automated configuration
- [ ] Settings recommendations

---

**Last Updated**: February 2026
