# Recruitment Management Module v2.0

## Overview

The Recruitment Management module provides comprehensive end-to-end recruitment capabilities with advanced features including organization-specific email configuration, candidate portal, interview management, job offer workflows, and recruitment analytics.

**Version**: 2.0 (Updated February 2026)

---

## 🆕 What's New in v2.0

### Organization-Specific Email Configuration
- Custom SMTP settings per organization
- Support for Gmail, Outlook, SendGrid, Mailgun
- Test email functionality
- Automatic fallback to system defaults

### Candidate Portal
- Self-service application tracking
- Two-way messaging with HR
- Application timeline view
- Application editing and withdrawal

### Interview Management
- Interview scheduling with notifications
- Confirmation/decline workflow
- Calendar integration
- Interview tracking

### Job Offer Management
- Digital offer creation
- PDF offer letter generation
- Online acceptance/decline
- Automatic employee onboarding

### Recruitment Analytics
- Application funnel analysis
- Time-to-hire metrics
- Source effectiveness tracking
- Export functionality

---

## Email Configuration

### Setup Email Settings

**Access**: Settings → Email Settings (`/settings/email-setup`)

**Required Permission**: `edit_organization_settings` or `edit_email_settings`

### Configuration Options

```yaml
Email Settings:
  use_custom_mail: boolean
  mail_driver: smtp|sendmail|mailgun|ses|postmark
  mail_host: string (e.g., smtp.gmail.com)
  mail_port: integer (e.g., 587)
  mail_username: string
  mail_password: string
  mail_encryption: tls|ssl|none
  mail_from_address: email
  mail_from_name: string
```

### Supported Email Providers

#### Gmail
```yaml
Host: smtp.gmail.com
Port: 587
Encryption: TLS
Username: your-email@gmail.com
Password: [App Password - NOT regular password]
```

**Important**: Gmail requires an App Password:
1. Go to Google Account → Security
2. Enable 2-Step Verification
3. Generate App Password for "Mail"
4. Use that password in settings

#### Microsoft 365/Outlook
```yaml
Host: smtp.office365.com
Port: 587
Encryption: TLS
Username: your-email@yourcompany.com
Password: [Your email password]
```

#### SendGrid
```yaml
Host: smtp.sendgrid.net
Port: 587
Encryption: TLS
Username: apikey
Password: [Your SendGrid API Key]
```

#### Mailgun
```yaml
Host: smtp.mailgun.org
Port: 587
Encryption: TLS
Username: [Your Mailgun username]
Password: [Your Mailgun password]
```

### Email Types

All recruitment emails now use organization-specific settings:

1. **ApplicationReceived** - Sent when candidate submits application
2. **ApplicationStatusChanged** - Sent when application status changes
3. **InterviewInvitation** - Sent for interview invitations
4. **InterviewScheduled** - Sent when interview is scheduled
5. **JobOfferSent** - Sent when job offer is created
6. **NewMessageFromCandidate** - Sent when candidate messages HR
7. **NewMessageFromHR** - Sent when HR messages candidate
8. **WelcomeNewEmployee** - Sent when new employee is onboarded

### Testing Email Configuration

1. Enter test email address
2. Click "Send Test"
3. Check inbox for test email
4. If successful, save settings

### Troubleshooting Email Issues

**Authentication Failed**:
- Gmail: Use App Password, not regular password
- Microsoft: Check if 2FA is enabled
- All: Verify username and password are correct

**Connection Timeout**:
- Check firewall allows port 587
- Try port 465 with SSL encryption
- Verify mail host is correct

**Emails Not Received**:
- Check spam/junk folder
- Verify "from" email is valid
- Check email provider logs
- Ensure queue worker is running

---

## Candidate Portal

### Features

#### Application Tracking
- **Tracking URL**: Unique URL sent via email after application
- **Real-time Status**: View current application status
- **Timeline View**: Visual timeline of application progress
- **Document Access**: Download submitted CV and documents

#### Messaging System
- **Two-way Communication**: Message HR directly
- **Email Notifications**: Get notified of new messages
- **Message History**: View all conversation history
- **Attachment Support**: Send and receive attachments

#### Application Management
- **Edit Application**: Update application before review
- **Withdraw Application**: Self-service withdrawal
- **Status Updates**: Receive email notifications on status changes

### Access Methods

1. **Email Link**: Click tracking link in confirmation email
2. **Direct URL**: `/track/{tracking_token}`
3. **Search**: Enter email and application reference

### Candidate Dashboard

```
┌─────────────────────────────────────────┐
│ Application Status: Shortlisted         │
│ Applied: Feb 10, 2024                   │
│ Last Updated: Feb 15, 2024              │
├─────────────────────────────────────────┤
│ Job: Software Developer                 │
│ Department: IT                          │
│ Location: Nairobi                       │
├─────────────────────────────────────────┤
│ [View Timeline] [Messages (2)]          │
│ [Download CV] [Withdraw Application]    │
└─────────────────────────────────────────┘
```

### Application Timeline

```
✓ Application Submitted
  Feb 10, 2024 10:30 AM
  
✓ Application Received
  Feb 10, 2024 10:31 AM
  Confirmation email sent
  
✓ Under Review
  Feb 12, 2024 2:15 PM
  Your application is being reviewed
  
● Shortlisted
  Feb 15, 2024 9:00 AM
  Congratulations! You've been shortlisted
  
○ Interview Scheduled
  Pending
  
○ Final Decision
  Pending
```

---

## Interview Management

### Interview Workflow

```
┌──────────────────┐
│ Schedule         │ ──► HR schedules interview
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Send Invitation  │ ──► Email sent to candidate
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Candidate Action │ ──► Confirm or Decline
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Conduct          │ ──► Interview takes place
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Feedback         │ ──► Interviewer provides feedback
└──────────────────┘
```

### Scheduling Interview

**Required Information**:
```yaml
Application: Select candidate
Scheduled At: Date and time
Location: Physical address or "Virtual"
Meeting Link: Video conference URL (optional)
Interviewer: Select from users
Notes: Internal notes (optional)
```

**Example**:
```
Candidate: John Doe
Position: Software Developer
Date: February 20, 2024
Time: 10:00 AM - 11:30 AM
Duration: 1.5 hours
Type: Technical Interview
Location: Virtual
Meeting Link: https://meet.google.com/abc-defg-hij
Interviewer: Jane Smith (Tech Lead)
```

### Interview Invitation Email

```
Subject: Interview Invitation - Software Developer Position

Dear John Doe,

We are pleased to invite you for an interview for the Software Developer position at Qaya Creatives.

Interview Details:
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Date: Wednesday, February 20, 2024
Time: 10:00 AM - 11:30 AM (EAT)
Duration: 1 hour 30 minutes
Type: Technical Interview
Location: Virtual Interview
Meeting Link: https://meet.google.com/abc-defg-hij
Interviewer: Jane Smith, Tech Lead

Please confirm your availability:
[Confirm Attendance] [Request Reschedule]

What to Prepare:
• Review the job description
• Prepare questions for us
• Test your internet connection
• Have your portfolio ready

If you have any questions, please reply to this email.

Best regards,
HR Team
Qaya Creatives
```

### Interview Confirmation

**Candidate Actions**:
1. Click confirmation link in email
2. View interview details
3. Choose action:
   - **Confirm**: Accept interview
   - **Decline**: Decline with optional reason
   - **Reschedule**: Request different time

**Confirmation Page**:
```
┌─────────────────────────────────────────┐
│ Interview Confirmation                   │
├─────────────────────────────────────────┤
│ Position: Software Developer             │
│ Date: Feb 20, 2024 at 10:00 AM         │
│ Duration: 1.5 hours                     │
│ Type: Technical Interview               │
│ Location: Virtual                       │
│ Meeting Link: [Join Meeting]            │
│ Interviewer: Jane Smith                 │
├─────────────────────────────────────────┤
│ [Confirm Attendance]                    │
│ [Decline Interview]                     │
│ [Request Reschedule]                    │
└─────────────────────────────────────────┘
```

### Interview Status

```
Scheduled   - Interview scheduled
Confirmed   - Candidate confirmed
Declined    - Candidate declined
Rescheduled - New time requested
Completed   - Interview conducted
Cancelled   - Interview cancelled
No-show     - Candidate didn't attend
```

---

## Job Offer Management

### Offer Creation Workflow

```
┌──────────────────┐
│ Create Offer     │ ──► HR creates offer details
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Review & Approve │ ──► Manager approval (optional)
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Generate PDF     │ ──► Offer letter generated
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Send to Candidate│ ──► Email with offer link
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Candidate Action │ ──► Accept or Decline
└────────┬─────────┘
         │
         ▼
┌──────────────────┐
│ Onboarding       │ ──► Create employee record
└──────────────────┘
```

### Offer Details

**Required Information**:
```yaml
Candidate: John Doe
Position Title: Software Developer
Department: IT Department
Start Date: March 15, 2024

Compensation:
  Salary: 100,000 KES/month
  Salary Period: monthly|annually
  Benefits: Health insurance, pension, etc.

Terms:
  Employment Type: Full-time|Part-time|Contract
  Probation Period: 3 months
  Notice Period: 1 month
  Work Schedule: Monday-Friday, 9 AM - 5 PM

Additional:
  Terms and Conditions: [Full text]
  Offer Expiry: 7 days from send date
```

### Offer Letter PDF

The system generates a professional PDF offer letter with:
- Company letterhead
- Offer details
- Compensation breakdown
- Terms and conditions
- Acceptance instructions
- Expiry date

### Offer Email

```
Subject: Job Offer - Software Developer Position

Dear John Doe,

Congratulations! We are pleased to offer you the position of Software Developer at Qaya Creatives.

Offer Summary:
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
Position: Software Developer
Department: IT Department
Start Date: March 15, 2024
Salary: KES 100,000 per month
Employment Type: Full-time

Please review the complete offer letter attached and respond by February 25, 2024.

[View Offer Letter] [Accept Offer] [Decline Offer]

We look forward to welcoming you to our team!

Best regards,
HR Team
Qaya Creatives
```

### Offer Acceptance

**Acceptance Page**:
```
┌─────────────────────────────────────────┐
│ Job Offer - Software Developer           │
├─────────────────────────────────────────┤
│ Salary: KES 100,000/month               │
│ Start Date: March 15, 2024              │
│ Employment Type: Full-time              │
│ Probation: 3 months                     │
├─────────────────────────────────────────┤
│ [Download Offer Letter PDF]             │
├─────────────────────────────────────────┤
│ This offer expires on: Feb 25, 2024     │
├─────────────────────────────────────────┤
│ [Accept Offer] [Decline Offer]          │
└─────────────────────────────────────────┘
```

**Acceptance Form**:
```
I, John Doe, accept the offer for the position of Software Developer.

Start Date Confirmation: [March 15, 2024]
Signature: [Digital Signature]
Date: [Auto-filled]

Additional Comments: [Optional]

[Submit Acceptance]
```

### Automatic Onboarding

When offer is accepted:
1. **Employee Record Created**
   - Personal information transferred
   - Employee code generated
   - Department assigned

2. **User Account Created**
   - Login credentials generated
   - Welcome email sent
   - Password reset link included

3. **Onboarding Checklist**
   - Documents to submit
   - Forms to complete
   - Orientation schedule

4. **Welcome Email**
   ```
   Subject: Welcome to Qaya Creatives!
   
   Dear John,
   
   Welcome to the team! We're excited to have you join us.
   
   Your employee details:
   Employee ID: EMP001234
   Start Date: March 15, 2024
   Department: IT Department
   
   Next Steps:
   1. Set up your account: [Set Password]
   2. Complete onboarding forms
   3. Review employee handbook
   4. Attend orientation on March 15
   
   Your manager, Jane Smith, will contact you soon.
   
   Welcome aboard!
   HR Team
   ```

### Offer Status

```
Draft     - Being prepared
Pending   - Awaiting approval
Approved  - Ready to send
Sent      - Sent to candidate
Accepted  - Candidate accepted
Declined  - Candidate declined
Expired   - Offer expired
Withdrawn - Offer withdrawn
```

---

## Recruitment Analytics

### Analytics Dashboard

**Access**: Recruitment → Analytics (`/recruitment/analytics`)

### Key Metrics

#### Application Funnel
```
Applications Received: 150
  ↓ 67% (100)
Screening Passed: 100
  ↓ 50% (50)
Shortlisted: 50
  ↓ 40% (20)
Interviewed: 20
  ↓ 50% (10)
Offers Made: 10
  ↓ 80% (8)
Offers Accepted: 8

Overall Conversion Rate: 5.3%
```

#### Time-to-Hire
```
Average Time to Hire: 28 days

Breakdown:
- Application to Screening: 3 days
- Screening to Shortlist: 5 days
- Shortlist to Interview: 7 days
- Interview to Offer: 10 days
- Offer to Acceptance: 3 days
```

#### Source Effectiveness
```
Job Boards: 45 applications (30% conversion)
LinkedIn: 35 applications (40% conversion)
Referrals: 25 applications (50% conversion)
Company Website: 20 applications (35% conversion)
Agencies: 15 applications (25% conversion)
Other: 10 applications (20% conversion)
```

#### Position Analysis
```
Open Positions: 12
Filled Positions: 8
Average Time to Fill: 32 days
Positions by Department:
- IT: 5 positions
- Sales: 3 positions
- HR: 2 positions
- Finance: 2 positions
```

### Reports

1. **Recruitment Pipeline Report**
   - Applications by stage
   - Conversion rates
   - Bottleneck identification

2. **Time-to-Hire Report**
   - Average time per stage
   - Comparison by position
   - Trend analysis

3. **Source Effectiveness Report**
   - Applications by source
   - Quality by source
   - Cost per hire

4. **Recruiter Performance Report**
   - Positions filled
   - Time to fill
   - Quality of hire

### Export Functionality

Export analytics data in:
- **PDF**: Formatted report
- **Excel**: Raw data for analysis
- **CSV**: Data import/export

---

## Application Messaging

### Features

- **Two-way Communication**: HR and candidates can message each other
- **Email Notifications**: Both parties notified of new messages
- **Attachment Support**: Send and receive files
- **Message History**: Complete conversation thread
- **Read Receipts**: See when messages are read

### HR Messaging

**Access**: Job Postings → View Applications → Messages

**Send Message**:
```
To: John Doe (john.doe@email.com)
Subject: Interview Preparation

Message:
Hi John,

Thank you for your interest in the Software Developer position.

I wanted to share some information to help you prepare for your upcoming interview:

1. Review our tech stack (React, Node.js, PostgreSQL)
2. Prepare examples of your previous work
3. Be ready to discuss your problem-solving approach

Looking forward to meeting you!

Best regards,
Jane Smith
HR Manager

[Attach File] [Send Message]
```

### Candidate Messaging

**Access**: Candidate Portal → Messages

**Send Message**:
```
Subject: Question about Interview

Message:
Hi,

I have a question about the upcoming interview. Will it be conducted in person or virtually?

Also, should I bring any specific documents?

Thank you!
John Doe

[Attach File] [Send Message]
```

### Message Notifications

**Email Notification**:
```
Subject: New Message About Your Application

You have received a new message regarding your application for Software Developer at Qaya Creatives.

From: Jane Smith (HR Manager)
Subject: Interview Preparation

[View Message]

To reply, visit your candidate portal or reply to this email.
```

---

## Permissions

### Email Settings Permissions

| Permission | Description |
|-----------|-------------|
| `view_email_settings` | View email settings page |
| `edit_email_settings` | Edit and save email settings |
| `test_email_settings` | Test email configuration |

### Recruitment Permissions

| Permission | Description |
|-----------|-------------|
| `create_job_postings` | Create new job postings |
| `edit_job_postings` | Edit existing postings |
| `delete_job_postings` | Delete job postings |
| `view_applications` | View applications |
| `screen_applications` | Screen and shortlist |
| `schedule_interviews` | Schedule interviews |
| `conduct_interviews` | Conduct and provide feedback |
| `make_offers` | Create and send offers |
| `view_recruitment_reports` | Access analytics |
| `export_recruitment_reports` | Export reports |

---

## API Endpoints

### Email Settings
```
GET    /settings/email-setup          - View email settings
PUT    /settings/email-setup          - Update email settings
POST   /settings/email-setup/test     - Test email configuration
```

### Applications
```
GET    /applications                  - List applications
GET    /applications/{id}             - View application
POST   /applications/{id}/status      - Update status
GET    /applications/{id}/messages    - View messages
POST   /applications/{id}/messages    - Send message
```

### Interviews
```
POST   /interviews                    - Schedule interview
GET    /interviews/{id}               - View interview
PUT    /interviews/{id}               - Update interview
GET    /interview/{token}             - Confirmation page
POST   /interview/{token}/confirm     - Confirm interview
POST   /interview/{token}/decline     - Decline interview
```

### Job Offers
```
POST   /applications/{id}/offer       - Create offer
GET    /job-offers/{id}               - View offer
POST   /job-offers/{id}/send          - Send offer
GET    /offer/{token}                 - View offer (candidate)
POST   /offer/{token}/accept          - Accept offer
POST   /offer/{token}/decline         - Decline offer
```

### Candidate Portal
```
GET    /track/{token}                 - Candidate dashboard
GET    /track/{token}/timeline        - Application timeline
GET    /track/{token}/messages        - View messages
POST   /track/{token}/messages        - Send message
GET    /track/{token}/edit            - Edit application
PUT    /track/{token}                 - Update application
POST   /track/{token}/withdraw        - Withdraw application
```

### Analytics
```
GET    /recruitment/analytics         - Analytics dashboard
GET    /recruitment/analytics/export  - Export analytics
```

---

## Testing

### Test Email Configuration

```bash
# Test all recruitment emails
php artisan recruitment:test-emails your-email@example.com

# Test specific application
php artisan recruitment:test-emails your-email@example.com --application-id=1
```

### Manual Testing Checklist

- [ ] Configure email settings
- [ ] Test email sending
- [ ] Submit test application
- [ ] Check confirmation email
- [ ] Update application status
- [ ] Check status change email
- [ ] Schedule interview
- [ ] Check interview invitation
- [ ] Confirm interview
- [ ] Create job offer
- [ ] Check offer email
- [ ] Accept offer
- [ ] Check welcome email
- [ ] Test candidate portal
- [ ] Test messaging system
- [ ] View analytics dashboard

---

## Troubleshooting

### Email Issues

**Problem**: Emails not being sent
**Solutions**:
1. Check email settings are configured
2. Verify SMTP credentials
3. Ensure queue worker is running: `php artisan queue:work`
4. Check logs: `storage/logs/laravel.log`

**Problem**: Emails going to spam
**Solutions**:
1. Configure SPF records for your domain
2. Set up DKIM signing
3. Use verified sender email
4. Warm up your sending domain

**Problem**: Queue jobs failing
**Solutions**:
1. Check failed jobs: `php artisan queue:failed`
2. Retry failed jobs: `php artisan queue:retry all`
3. Clear failed jobs: `php artisan queue:flush`
4. Restart queue worker: `php artisan queue:restart`

### Application Issues

**Problem**: Candidate not receiving tracking link
**Solutions**:
1. Check email address is correct
2. Check spam folder
3. Resend confirmation email
4. Verify email settings

**Problem**: Cannot access candidate portal
**Solutions**:
1. Verify tracking token is valid
2. Check URL is correct
3. Clear browser cache
4. Try different browser

### Interview Issues

**Problem**: Interview invitation not sent
**Solutions**:
1. Check email configuration
2. Verify candidate email
3. Check queue is processing
4. Review error logs

**Problem**: Confirmation link not working
**Solutions**:
1. Check token is valid
2. Verify interview exists
3. Check URL format
4. Try regenerating link

---

## Best Practices

### Email Configuration
1. Use dedicated email for system notifications
2. Test configuration before going live
3. Monitor email delivery rates
4. Set up SPF/DKIM records
5. Use App Passwords for Gmail
6. Keep credentials secure

### Recruitment Process
1. Respond to applications within 48 hours
2. Keep candidates informed of status
3. Provide interview feedback promptly
4. Make offers within 24 hours of decision
5. Follow up with candidates regularly
6. Maintain professional communication

### Data Management
1. Keep candidate data secure
2. Follow GDPR/data protection laws
3. Archive old applications
4. Backup recruitment data regularly
5. Monitor system performance
6. Review analytics monthly

---

## Future Enhancements

### Planned Features
- [ ] Email template customization per organization
- [ ] Email delivery tracking and analytics
- [ ] Bounce handling and suppression lists
- [ ] Multi-language email support
- [ ] Interview scheduling calendar integration
- [ ] Video interview integration
- [ ] AI-powered CV screening
- [ ] Automated reference checking
- [ ] Candidate assessment tests
- [ ] Social media integration

---

## Support

For issues or questions:
- Review [Troubleshooting Guide](../TROUBLESHOOTING.md)
- Check [FAQ](../FAQ.md)
- Check [CHANGELOG](../CHANGELOG.md)
- Contact system administrator

---

**Module Version**: 2.0  
**Last Updated**: February 8, 2026  
**Documentation Status**: Complete

