# Attendance Management Module

## Overview

The Attendance Management module provides comprehensive time tracking with employee self-service check-in/check-out, configurable time windows, automatic status detection, and detailed attendance reports.

---

## Features

### Core Functionality
- ✅ Employee self-service check-in/check-out
- ✅ Admin-configurable time windows
- ✅ Automatic status detection (Present, Late, Half Day, Absent)
- ✅ IP address logging for security
- ✅ Manual attendance marking by HR
- ✅ Monthly attendance reports
- ✅ Dashboard quick actions
- ✅ Attendance calendar view
- ✅ Export to Excel/PDF
- ✅ Real-time attendance tracking

---

## Attendance Status Types

### Status Definitions

1. **Present**
   - Checked in within allowed time
   - Worked full day hours
   - No late arrival

2. **Late**
   - Checked in after late threshold
   - Example: Check-in after 9:15 AM (if threshold is 15 minutes)

3. **Half Day**
   - Worked less than full day hours but more than half day hours
   - Example: Worked 4-7 hours (if full day is 8 hours)

4. **Absent**
   - No check-in record
   - Marked absent by system or HR

5. **On Leave**
   - Approved leave for the day
   - Not counted as absent

6. **Holiday**
   - Public holiday
   - Not counted as working day

7. **Weekend**
   - Saturday/Sunday (configurable)
   - Optional weekend check-in

---

## Attendance Settings

### Configurable Parameters

**Access**: Settings → Attendance Settings

**Time Windows**:

1. **Check-in Time Window**
   ```
   - Earliest Check-in Time: 06:00 AM (default)
   - Latest Check-in Time: 12:00 PM (default)
   - Employees can check in within this window
   ```

2. **Check-out Time Window**
   ```
   - Earliest Check-out Time: 03:00 PM (default)
   - Latest Check-out Time: 11:59 PM (default)
   - Employees can check out within this window
   ```

3. **Official Work Hours**
   ```
   - Work Start Time: 09:00 AM (default)
   - Work End Time: 05:00 PM (default)
   - Standard 8-hour workday
   ```

4. **Thresholds**
   ```
   - Late Arrival Threshold: 15 minutes (default)
   - Early Leave Threshold: 15 minutes (default)
   - Half Day Hours: 4 hours (default)
   - Full Day Hours: 8 hours (default)
   ```

5. **Additional Settings**
   ```
   - Allow Weekend Check-in: Yes/No
   - Require Check-out: Yes/No
   - Auto Check-out Time: 11:59 PM
   - Grace Period: 5 minutes
   ```

---

## User Interface

### Employee Self-Service

#### Dashboard Quick Actions

**Check-in Button**:
```
┌─────────────────────────────────┐
│  ⏰ Check In                     │
│  Current Time: 08:45 AM          │
│  Status: Not Checked In          │
│  [Check In Now]                  │
└─────────────────────────────────┘
```

**Check-out Button** (after check-in):
```
┌─────────────────────────────────┐
│  ⏰ Check Out                    │
│  Checked In: 08:45 AM            │
│  Duration: 7h 30m                │
│  [Check Out Now]                 │
└─────────────────────────────────┘
```

#### Attendance Page

**Access**: Dashboard → Attendance

**My Attendance Tab**:
- Current month calendar view
- Check-in/Check-out buttons
- Today's status
- Monthly summary

**Features**:
- One-click check-in/check-out
- Real-time status updates
- Attendance history
- Monthly statistics

### HR/Admin Interface

#### Attendance List View

**Access**: Dashboard → Attendance → All Attendance

**Features**:
- Paginated attendance list
- Search by employee name
- Filter by:
  - Date range
  - Department
  - Status
  - Employee
- Sort by:
  - Date
  - Check-in time
  - Status
- Bulk actions

**Columns Displayed**:
- Date
- Employee Name
- Check-in Time
- Check-out Time
- Hours Worked
- Status
- IP Address
- Actions

#### Manual Attendance Marking

**Access**: Attendance → Create

**Form Fields**:
```
- Employee * (Dropdown/Search)
- Date * (Date picker)
- Check-in Time * (Time picker)
- Check-out Time (Time picker)
- Status * (Dropdown)
- Notes (Textarea)
- Override Auto-calculation (Checkbox)
```

**Use Cases**:
- Mark attendance for employees without system access
- Correct attendance errors
- Record field work attendance
- Handle special cases

---

## Attendance Calculation Logic

### Auto Status Detection

**Algorithm**:

```javascript
1. Check if check-in exists
   - No check-in → Status: Absent

2. Check if on approved leave
   - On leave → Status: On Leave

3. Check if holiday
   - Holiday → Status: Holiday

4. Calculate check-in time difference
   - Check-in > (Work Start + Late Threshold)
   → Status: Late

5. Calculate hours worked
   - Hours < Half Day Hours → Status: Half Day
   - Hours >= Full Day Hours → Status: Present
   - In between → Status: Half Day

6. Check early leave
   - Check-out < (Work End - Early Leave Threshold)
   → Flag: Early Leave
```

**Example Scenarios**:

**Scenario 1: On-time arrival, full day**
```
Check-in: 08:50 AM
Check-out: 05:10 PM
Hours Worked: 8h 20m
Status: Present
```

**Scenario 2: Late arrival, full day**
```
Check-in: 09:20 AM (Late by 20 minutes)
Check-out: 05:30 PM
Hours Worked: 8h 10m
Status: Late
```

**Scenario 3: On-time, half day**
```
Check-in: 09:00 AM
Check-out: 01:00 PM
Hours Worked: 4h 0m
Status: Half Day
```

**Scenario 4: No check-in**
```
Check-in: None
Check-out: None
Status: Absent
```

---

## Check-in/Check-out Process

### Employee Check-in

**Steps**:
1. Employee clicks "Check In" button
2. System validates:
   - Current time is within check-in window
   - No existing check-in for today
   - Employee is active
3. System records:
   - Check-in timestamp
   - IP address
   - Device information (optional)
4. System displays confirmation
5. Status updated to "Checked In"

**Validation Rules**:
- Cannot check in before earliest check-in time
- Cannot check in after latest check-in time
- Cannot check in twice on same day
- Cannot check in on behalf of others

### Employee Check-out

**Steps**:
1. Employee clicks "Check Out" button
2. System validates:
   - Check-in exists for today
   - No existing check-out
   - Current time is within check-out window
3. System records:
   - Check-out timestamp
   - IP address
4. System calculates:
   - Hours worked
   - Status (Present/Late/Half Day)
5. System displays summary

**Validation Rules**:
- Cannot check out before check-in
- Cannot check out before earliest check-out time
- Cannot check out twice
- Minimum work duration (e.g., 1 hour)

---

## Attendance Reports

### Monthly Attendance Report

**Access**: Reports → Attendance

**Filters**:
- Month and Year
- Department
- Employee
- Status

**Report Contents**:
```
Employee: John Doe (EMP001)
Department: IT Department
Month: February 2024

┌──────┬────────────┬──────────┬───────────┬───────┬─────────┐
│ Date │ Check-in   │ Check-out│ Hours     │ Status│ Notes   │
├──────┼────────────┼──────────┼───────────┼───────┼─────────┤
│ 01   │ 08:45 AM   │ 05:15 PM │ 8h 30m    │ Present│        │
│ 02   │ 09:20 AM   │ 05:30 PM │ 8h 10m    │ Late   │        │
│ 03   │ -          │ -        │ -         │ Weekend│        │
│ 04   │ -          │ -        │ -         │ Weekend│        │
│ 05   │ 08:50 AM   │ 01:00 PM │ 4h 10m    │ Half Day│       │
└──────┴────────────┴──────────┴───────────┴───────┴─────────┘

Summary:
- Total Working Days: 20
- Days Present: 15
- Days Late: 3
- Half Days: 1
- Days Absent: 1
- Attendance Rate: 95%
```

**Export Options**:
- PDF
- Excel
- CSV

### Department Attendance Summary

**Report Contents**:
- Department-wise attendance statistics
- Comparison across departments
- Trend analysis
- Top performers
- Attendance issues

### Attendance Trends Report

**Report Contents**:
- Monthly trends
- Seasonal patterns
- Late arrival analysis
- Early leave analysis
- Absenteeism rate

---

## Integration with Other Modules

### Leave Management
- Approved leaves marked as "On Leave"
- Not counted as absent
- Automatic status update

### Payroll
- Attendance data used for salary calculation
- Absent days deducted from salary
- Half days calculated proportionally
- Late arrivals may affect salary (configurable)

### Performance Management
- Attendance record considered in reviews
- Punctuality metrics
- Reliability assessment

---

## Permissions

### Required Permissions

| Action | Permission | Description |
|--------|-----------|-------------|
| View Own Attendance | Default (All employees) | View personal attendance |
| Check-in/Check-out | Default (All employees) | Self-service attendance |
| View All Attendance | `view_attendance` | View all employee attendance |
| Mark Attendance | `manage_attendance` | Manually mark attendance |
| Edit Attendance | `manage_attendance` | Modify attendance records |
| Delete Attendance | `manage_attendance` | Remove attendance records |
| View Reports | `view_reports` | Access attendance reports |
| Configure Settings | `manage_settings` | Modify attendance settings |

---

## API Endpoints

### Check-in
```http
POST /attendance/check-in
```

**Response**:
```json
{
  "success": true,
  "message": "Checked in successfully",
  "data": {
    "id": 123,
    "employee_id": 1,
    "date": "2024-02-15",
    "check_in": "08:45:00",
    "ip_address": "192.168.1.100"
  }
}
```

### Check-out
```http
POST /attendance/check-out
```

**Response**:
```json
{
  "success": true,
  "message": "Checked out successfully",
  "data": {
    "id": 123,
    "check_out": "17:15:00",
    "hours_worked": "8.5",
    "status": "present"
  }
}
```

### Get Attendance
```http
GET /attendance?employee_id=1&month=2&year=2024
```

### Mark Attendance (Admin)
```http
POST /attendance
```

**Request Body**:
```json
{
  "employee_id": 1,
  "date": "2024-02-15",
  "check_in": "09:00:00",
  "check_out": "17:00:00",
  "status": "present",
  "notes": "Field work"
}
```

---

## Best Practices

### For Employees
1. Check in as soon as you arrive
2. Don't forget to check out
3. Report issues immediately
4. Use correct device/location
5. Review monthly attendance

### For HR/Managers
1. Monitor daily attendance
2. Follow up on absences
3. Address late arrivals
4. Review monthly reports
5. Configure settings appropriately

### For System Admins
1. Regular data backups
2. Monitor system performance
3. Review IP logs for security
4. Update settings as needed
5. Train users on system

---

## Troubleshooting

### Common Issues

**Issue**: Cannot check in
- **Solution**: Verify time is within check-in window, check internet connection

**Issue**: Check-in button not showing
- **Solution**: Verify employee status is active, check permissions

**Issue**: Incorrect status calculation
- **Solution**: Review attendance settings, verify time thresholds

**Issue**: Missing attendance records
- **Solution**: Check date range, verify employee assignment

**Issue**: Cannot check out
- **Solution**: Verify check-in exists, check time window settings

---

## Future Enhancements

- [ ] Biometric integration
- [ ] GPS-based check-in
- [ ] Mobile app support
- [ ] Facial recognition
- [ ] Shift management
- [ ] Overtime tracking
- [ ] Break time tracking
- [ ] Attendance forecasting

---

**Last Updated**: February 2026
