# Payroll Management Module

## Overview

The Payroll Management module provides comprehensive payroll processing capabilities with Kenya tax compliance (PAYE, NHIF, NSSF, Housing Levy), automatic calculations, bulk generation, and approval workflows.

---

## Features

### Core Functionality
- ✅ Monthly payroll generation
- ✅ Individual and bulk payroll processing
- ✅ Kenya tax compliance (PAYE, NHIF, NSSF, Housing Levy)
- ✅ Attendance-based salary calculation
- ✅ Automatic loan deductions
- ✅ HELB loan deductions
- ✅ Custom allowances and deductions
- ✅ Payroll approval workflow
- ✅ Payslip generation (PDF)
- ✅ Payroll reports and exports
- ✅ Bank file generation
- ✅ Payroll calculator

---

## Payroll Components

### Earnings
1. **Basic Salary**
   - Base salary from employee record
   - Pro-rated for partial months

2. **Allowances**
   - House Allowance
   - Transport Allowance
   - Medical Allowance
   - Other Allowances (Custom)

3. **Bonuses**
   - Performance Bonus
   - Annual Bonus
   - Commission
   - Overtime Pay

4. **Benefits**
   - Non-cash benefits
   - Taxable benefits

### Deductions

#### Statutory Deductions
1. **PAYE (Pay As You Earn)**
   - Kenya income tax
   - Progressive tax bands
   - Personal relief applied

2. **NHIF (National Hospital Insurance Fund)**
   - Based on gross salary
   - Fixed contribution bands

3. **NSSF (National Social Security Fund)**
   - Tier I and Tier II contributions
   - Capped at maximum amounts

4. **Housing Levy**
   - 1.5% of gross salary
   - Mandatory contribution

#### Other Deductions
1. **Loan Repayments**
   - Employee loans
   - Automatic deduction

2. **HELB (Higher Education Loans Board)**
   - Monthly deduction
   - If employee has HELB loan

3. **Advances**
   - Salary advances
   - One-time deductions

4. **Custom Deductions**
   - Insurance premiums
   - Savings schemes
   - Union dues
   - Other deductions

---

## Kenya Tax Calculations

### PAYE Calculation (2024/2025 Rates)

**Tax Bands**:
```
Monthly Income          Rate
KES 0 - 24,000         10%
KES 24,001 - 32,333    25%
KES 32,334 - 500,000   30%
KES 500,001 - 800,000  32.5%
Above KES 800,000      35%
```

**Personal Relief**: KES 2,400 per month

**Example Calculation**:
```
Gross Salary: KES 80,000

Taxable Income: KES 80,000
Tax Calculation:
  First 24,000 @ 10%    = KES 2,400
  Next 8,333 @ 25%      = KES 2,083
  Next 47,667 @ 30%     = KES 14,300
  Total Tax             = KES 18,783
  Less Personal Relief  = KES 2,400
  PAYE                  = KES 16,383
```

### NHIF Calculation

**Contribution Bands**:
```
Gross Salary Range      NHIF
KES 0 - 5,999          KES 150
KES 6,000 - 7,999      KES 300
KES 8,000 - 11,999     KES 400
KES 12,000 - 14,999    KES 500
KES 15,000 - 19,999    KES 600
KES 20,000 - 24,999    KES 750
KES 25,000 - 29,999    KES 850
KES 30,000 - 34,999    KES 900
KES 35,000 - 39,999    KES 950
KES 40,000 - 44,999    KES 1,000
KES 45,000 - 49,999    KES 1,100
KES 50,000 - 59,999    KES 1,200
KES 60,000 - 69,999    KES 1,300
KES 70,000 - 79,999    KES 1,400
KES 80,000 - 89,999    KES 1,500
KES 90,000 - 99,999    KES 1,600
KES 100,000+           KES 1,700
```

### NSSF Calculation

**Contribution Structure**:
```
Tier I:  KES 7,000 @ 6% = KES 420 (Employee + Employer each)
Tier II: Up to KES 36,000 @ 6% = KES 2,160 (Employee + Employer each)

Maximum Employee Contribution: KES 2,160 per month
Maximum Employer Contribution: KES 2,160 per month
```

### Housing Levy Calculation

**Rate**: 1.5% of gross salary

**Example**:
```
Gross Salary: KES 80,000
Housing Levy: 80,000 × 1.5% = KES 1,200
```

---

## Payroll Workflow

### Payroll Lifecycle

```
┌──────────────┐
│    Draft     │ ──► Payroll created, calculations done
└──────┬───────┘
       │
       ▼
┌──────────────┐
│   Pending    │ ──► Awaiting approval
└──────┬───────┘
       │
       ▼
┌──────────────┐
│   Approved   │ ──► Approved by authorized person
└──────┬───────┘
       │
       ▼
┌──────────────┐
│  Processed   │ ──► Ready for payment
└──────┬───────┘
       │
       ▼
┌──────────────┐
│     Paid     │ ──► Payment completed
└──────────────┘
       │
       ▼ (Alternative)
┌──────────────┐
│   Rejected   │ ──► Rejected, needs revision
└──────────────┘
```

---

## User Interface

### Payroll List View

**Access**: Dashboard → Payroll

**Features**:
- Paginated payroll list
- Search by employee name or payroll ID
- Filter by:
  - Month
  - Year
  - Status
  - Department
- Sort by:
  - Employee Name
  - Net Salary
  - Status
- Bulk actions (Approve, Process, Export)

**Columns Displayed**:
- Payroll ID
- Employee Name
- Month/Year
- Gross Salary
- Total Deductions
- Net Salary
- Status
- Actions

### Payroll Detail View

**Access**: Payroll → Click payroll ID

**Sections**:

1. **Employee Information**
   ```
   - Employee Name
   - Employee Code
   - Department
   - Position
   - Bank Account Details
   ```

2. **Payroll Period**
   ```
   - Month
   - Year
   - Working Days
   - Days Worked
   - Days Absent
   ```

3. **Earnings Breakdown**
   ```
   - Basic Salary
   - House Allowance
   - Transport Allowance
   - Other Allowances
   - Bonuses
   - Overtime
   - Gross Salary
   ```

4. **Statutory Deductions**
   ```
   - PAYE
   - NHIF
   - NSSF
   - Housing Levy
   ```

5. **Other Deductions**
   ```
   - Loan Repayments
   - HELB Deduction
   - Advances
   - Other Deductions
   - Total Deductions
   ```

6. **Net Salary**
   ```
   - Gross Salary
   - Total Deductions
   - Net Salary (Take Home)
   ```

7. **Actions**
   ```
   - Download Payslip (PDF)
   - Approve/Reject
   - Mark as Paid
   - Edit (if draft)
   - Delete (if draft)
   ```

### Create Payroll Form

**Individual Payroll**:

1. **Employee Selection**
   ```
   - Employee * (Dropdown/Search)
   - Auto-populate employee details
   ```

2. **Payroll Period**
   ```
   - Month * (Dropdown)
   - Year * (Number)
   ```

3. **Earnings**
   ```
   - Basic Salary (Auto-filled)
   - House Allowance
   - Transport Allowance
   - Medical Allowance
   - Other Allowances
   - Bonuses
   - Overtime Hours
   - Overtime Rate
   ```

4. **Additional Deductions**
   ```
   - Custom Deduction Name
   - Custom Deduction Amount
   - Notes
   ```

5. **Calculation Preview**
   ```
   - Gross Salary (Calculated)
   - PAYE (Calculated)
   - NHIF (Calculated)
   - NSSF (Calculated)
   - Housing Levy (Calculated)
   - Loan Deductions (Auto-fetched)
   - HELB Deduction (Auto-fetched)
   - Total Deductions (Calculated)
   - Net Salary (Calculated)
   ```

**Bulk Payroll Generation**:

1. **Selection Criteria**
   ```
   - Month * (Dropdown)
   - Year * (Number)
   - Department (Optional filter)
   - Employee Status (Active by default)
   ```

2. **Options**
   ```
   - Include Attendance Data (Checkbox)
   - Include Loan Deductions (Checkbox)
   - Include HELB Deductions (Checkbox)
   - Auto-approve (Checkbox)
   ```

3. **Preview**
   ```
   - Number of employees
   - Total gross salary
   - Total deductions
   - Total net salary
   ```

4. **Generate**
   ```
   - Click "Generate Payroll"
   - System creates payroll for all eligible employees
   - Shows success/error summary
   ```

---

## Payroll Calculator

**Access**: Payroll → Calculator

**Purpose**: Calculate net salary before creating payroll

**Inputs**:
- Basic Salary
- Allowances
- Bonuses
- Custom Deductions

**Outputs**:
- Gross Salary
- PAYE
- NHIF
- NSSF
- Housing Levy
- Total Deductions
- Net Salary

**Features**:
- Real-time calculation
- No data saved
- Educational tool
- Salary negotiation aid

---

## Payroll Settings

**Access**: Payroll → Settings

**Configurable Parameters**:

1. **Tax Rates**
   ```
   - PAYE tax bands
   - Personal relief amount
   - NHIF contribution bands
   - NSSF rates (Tier I & II)
   - Housing levy rate
   ```

2. **Allowances**
   ```
   - Default allowance types
   - Taxable/Non-taxable flags
   - Default amounts
   ```

3. **Deductions**
   ```
   - Default deduction types
   - Calculation methods
   - Maximum limits
   ```

4. **Approval Workflow**
   ```
   - Enable/disable approval
   - Required approvers
   - Approval levels
   ```

5. **Payslip Settings**
   ```
   - Company logo
   - Header/footer text
   - Display options
   ```

---

## Permissions

### Required Permissions

| Action | Permission | Description |
|--------|-----------|-------------|
| View Payroll | `view_payroll` | View payroll list and details |
| Create Payroll | `manage_payroll` | Create individual payroll |
| Bulk Generate | `manage_payroll` | Generate bulk payroll |
| Approve Payroll | `approve_payroll` | Approve payroll for processing |
| Process Payroll | `manage_payroll` | Mark payroll as processed |
| Mark as Paid | `manage_payroll` | Mark payroll as paid |
| Edit Payroll | `manage_payroll` | Modify payroll (draft only) |
| Delete Payroll | `manage_payroll` | Remove payroll (draft only) |
| View Settings | `manage_payroll` | View payroll settings |
| Edit Settings | `manage_payroll` | Modify payroll settings |

---

## Attendance Integration

### Attendance-Based Calculation

**Process**:
1. System retrieves attendance records for the month
2. Calculates:
   - Total working days
   - Days present
   - Days absent
   - Late arrivals
   - Early departures
3. Applies salary deductions for absences
4. Calculates pro-rated salary

**Deduction Rules**:
- Full day absence: Deduct 1 day salary
- Half day: Deduct 0.5 day salary
- Late arrival (beyond threshold): Warning or deduction
- Unpaid leave: Deduct days

**Formula**:
```
Daily Rate = Basic Salary / Working Days in Month
Salary Deduction = Daily Rate × Days Absent
Adjusted Basic Salary = Basic Salary - Salary Deduction
```

---

## Payslip Generation

### Payslip Format

**Header**:
- Company logo
- Company name and address
- Payslip title
- Month and year

**Employee Details**:
- Employee name and code
- Department and position
- Bank account details
- NSSF, NHIF, KRA PIN

**Earnings Section**:
- Basic salary
- Allowances (itemized)
- Bonuses
- Gross salary

**Deductions Section**:
- PAYE
- NHIF
- NSSF
- Housing Levy
- Loan repayments
- Other deductions
- Total deductions

**Net Salary**:
- Gross salary
- Total deductions
- Net salary (bold/highlighted)

**Footer**:
- Generated date
- Authorized signature
- Company seal

### Download Options
- PDF format
- Email to employee
- Bulk download (ZIP)

---

## Reports

### Available Reports

1. **Monthly Payroll Summary**
   - Total employees paid
   - Total gross salary
   - Total deductions breakdown
   - Total net salary
   - Department-wise breakdown

2. **Statutory Deductions Report**
   - PAYE summary
   - NHIF summary
   - NSSF summary
   - Housing Levy summary
   - Remittance details

3. **Payroll Comparison Report**
   - Month-over-month comparison
   - Year-over-year comparison
   - Trend analysis

4. **Employee Payroll History**
   - Individual employee payroll over time
   - Salary progression
   - Deduction history

5. **Bank Transfer Report**
   - Bank-wise grouping
   - Account numbers
   - Net salary amounts
   - Transfer file generation

---

## API Endpoints

### List Payroll
```http
GET /payroll
```

### Get Payroll Details
```http
GET /payroll/{id}
```

### Create Payroll
```http
POST /payroll
```

**Request Body**:
```json
{
  "employee_id": 1,
  "month": 2,
  "year": 2024,
  "basic_salary": 80000,
  "allowances": {
    "house": 20000,
    "transport": 10000
  },
  "bonuses": {
    "performance": 5000
  }
}
```

### Bulk Generate Payroll
```http
POST /payroll/bulk
```

**Request Body**:
```json
{
  "month": 2,
  "year": 2024,
  "department_id": null,
  "include_attendance": true,
  "include_loans": true
}
```

### Approve Payroll
```http
POST /payroll/{id}/approve
```

### Reject Payroll
```http
POST /payroll/{id}/reject
```

### Process Payroll
```http
POST /payroll/{id}/process
```

### Mark as Paid
```http
POST /payroll/{id}/mark-paid
```

---

## Best Practices

### For HR/Payroll Officers
1. Generate payroll at least 3 days before payment date
2. Review all calculations before approval
3. Verify attendance data is complete
4. Check for new loans or deductions
5. Reconcile with previous month
6. Keep backup of payroll data

### For Approvers
1. Review summary reports
2. Check for anomalies
3. Verify statutory compliance
4. Ensure budget alignment
5. Document approval decisions

### For Employees
1. Review payslip carefully
2. Report discrepancies immediately
3. Keep payslips for records
4. Understand deductions
5. Plan finances based on net salary

---

## Troubleshooting

### Common Issues

**Issue**: Incorrect PAYE calculation
- **Solution**: Verify tax bands in settings, check personal relief

**Issue**: Loan not deducted
- **Solution**: Ensure loan status is "Active", check payroll period

**Issue**: Cannot approve payroll
- **Solution**: Verify approval permissions, check payroll status

**Issue**: Payslip not generating
- **Solution**: Check PDF library, verify template exists

**Issue**: Bulk generation fails
- **Solution**: Check employee eligibility, verify data completeness

---

## Future Enhancements

- [ ] Multi-currency support
- [ ] Payroll forecasting
- [ ] Salary increment automation
- [ ] Bonus calculation rules
- [ ] Integration with accounting systems
- [ ] Mobile payslip access
- [ ] Payroll analytics dashboard
- [ ] Automated bank file generation

---

**Last Updated**: February 2026
