# Loan Management Module

## Overview

The Loan Management module provides comprehensive tools for managing employee loans, including loan applications, approvals, disbursements, and repayment tracking with automatic payroll deductions.

---

## Features

### Core Functionality
- ✅ Employee loan applications
- ✅ Multi-stage approval workflow
- ✅ Loan disbursement tracking
- ✅ Automatic payroll deductions
- ✅ Repayment schedule management
- ✅ Interest calculation (Simple & Compound)
- ✅ Early repayment support
- ✅ Loan balance tracking
- ✅ Loan history and reports
- ✅ Configurable loan settings

---

## Loan Types

### Supported Loan Categories
1. **Personal Loan**
   - General purpose loans
   - Flexible terms
   - Standard interest rates

2. **Emergency Loan**
   - Quick approval process
   - Short-term loans
   - Higher interest rates

3. **Salary Advance**
   - Short-term advances
   - Deducted from next salary
   - Minimal or no interest

4. **Education Loan**
   - For educational purposes
   - Longer repayment terms
   - Lower interest rates

5. **Housing Loan**
   - For housing needs
   - Extended repayment period
   - Competitive rates

---

## Loan Workflow

### Loan Lifecycle

```
┌─────────────┐
│  Pending    │ ──► Employee submits loan application
└──────┬──────┘
       │
       ▼
┌─────────────┐
│  Approved   │ ──► Manager/HR approves loan
└──────┬──────┘
       │
       ▼
┌─────────────┐
│  Disbursed  │ ──► Loan amount disbursed to employee
└──────┬──────┘
       │
       ▼
┌─────────────┐
│   Active    │ ──► Repayments in progress
└──────┬──────┘
       │
       ▼
┌─────────────┐
│  Completed  │ ──► Loan fully repaid
└─────────────┘
       │
       ▼ (Alternative)
┌─────────────┐
│  Rejected   │ ──► Loan application rejected
└─────────────┘
```

---

## Loan Information Structure

### Basic Loan Details
- **Loan Reference Number** (Auto-generated)
- **Employee** (Borrower)
- **Loan Type**
- **Loan Amount**
- **Interest Rate** (%)
- **Interest Type** (Simple/Compound)
- **Repayment Period** (months)
- **Monthly Installment**
- **Application Date**
- **Purpose/Reason**

### Approval Information
- **Status** (Pending, Approved, Rejected, Disbursed, Active, Completed)
- **Approved By**
- **Approved Date**
- **Approval Notes**
- **Rejection Reason**

### Disbursement Information
- **Disbursement Date**
- **Disbursement Method** (Bank Transfer, Cash, Cheque)
- **Disbursement Reference**
- **Disbursed By**

### Repayment Information
- **Total Amount to Repay**
- **Amount Paid**
- **Balance Remaining**
- **Next Payment Date**
- **Payment Status**
- **Repayment History**

---

## User Interface

### Loan List View

**Access**: Dashboard → Loans

**Features**:
- Paginated loan list
- Search by employee name or loan reference
- Filter by:
  - Loan Type
  - Status
  - Date Range
- Sort by:
  - Application Date
  - Loan Amount
  - Status
- Quick actions (View, Approve, Disburse)

**Columns Displayed**:
- Loan Reference
- Employee Name
- Loan Type
- Amount
- Interest Rate
- Repayment Period
- Status
- Application Date
- Actions

### Loan Detail View

**Access**: Loans → Click loan reference

**Sections**:

1. **Loan Summary**
   ```
   - Loan Reference Number
   - Employee Information
   - Loan Type
   - Loan Amount
   - Interest Rate & Type
   - Repayment Period
   - Monthly Installment
   - Total Repayable Amount
   - Current Status
   ```

2. **Application Details**
   ```
   - Application Date
   - Purpose/Reason
   - Supporting Documents
   - Employee Comments
   ```

3. **Approval Information**
   ```
   - Approval Status
   - Approved/Rejected By
   - Approval Date
   - Approval Notes
   - Rejection Reason (if rejected)
   ```

4. **Disbursement Details**
   ```
   - Disbursement Date
   - Disbursement Method
   - Disbursement Reference
   - Disbursed By
   - Bank Details
   ```

5. **Repayment Schedule**
   ```
   Table showing:
   - Payment Number
   - Due Date
   - Principal Amount
   - Interest Amount
   - Total Payment
   - Status (Paid/Pending)
   - Payment Date
   ```

6. **Repayment History**
   ```
   - Payment Date
   - Amount Paid
   - Payment Method
   - Reference Number
   - Processed By
   ```

7. **Loan Balance**
   ```
   - Original Loan Amount
   - Total Interest
   - Total Repayable
   - Amount Paid
   - Balance Remaining
   - Progress Bar
   ```

### Create Loan Application Form

**Sections**:

1. **Employee Selection**
   ```
   - Employee * (Dropdown/Search)
   - Employee Details (Auto-populated)
     - Department
     - Position
     - Basic Salary
     - Existing Loans
   ```

2. **Loan Details**
   ```
   - Loan Type * (Dropdown)
   - Loan Amount * (Number)
   - Interest Rate * (%)
   - Interest Type * (Simple/Compound)
   - Repayment Period * (months)
   - Purpose/Reason * (Textarea)
   ```

3. **Calculation Preview**
   ```
   - Monthly Installment (Calculated)
   - Total Interest (Calculated)
   - Total Repayable Amount (Calculated)
   - First Payment Date
   - Last Payment Date
   ```

4. **Supporting Documents**
   ```
   - Document Upload (Optional)
   - Document Type
   - Notes
   ```

---

## Permissions

### Required Permissions

| Action | Permission | Description |
|--------|-----------|-------------|
| View Loans | `view_payroll` | View loan list and details |
| Create Loan | `manage_payroll` | Create new loan applications |
| Approve Loan | `manage_payroll` | Approve/reject loan applications |
| Disburse Loan | `manage_payroll` | Mark loans as disbursed |
| Edit Loan | `manage_payroll` | Modify loan information |
| Delete Loan | `manage_payroll` | Remove loan records |
| Process Repayment | `manage_payroll` | Record loan repayments |

---

## Loan Calculations

### Interest Calculation

#### Simple Interest
```
Interest = (Principal × Rate × Time) / 100
Total Amount = Principal + Interest
Monthly Installment = Total Amount / Number of Months
```

**Example**:
- Principal: KES 100,000
- Rate: 10% per annum
- Time: 12 months

```
Interest = (100,000 × 10 × 1) / 100 = KES 10,000
Total Amount = 100,000 + 10,000 = KES 110,000
Monthly Installment = 110,000 / 12 = KES 9,166.67
```

#### Compound Interest
```
Amount = Principal × (1 + Rate/100)^Time
Interest = Amount - Principal
Monthly Installment = Amount / Number of Months
```

**Example**:
- Principal: KES 100,000
- Rate: 10% per annum
- Time: 1 year

```
Amount = 100,000 × (1 + 0.10)^1 = KES 110,000
Interest = 110,000 - 100,000 = KES 10,000
Monthly Installment = 110,000 / 12 = KES 9,166.67
```

### Repayment Schedule Generation

**Monthly Breakdown**:
```
For each month:
  - Payment Number
  - Due Date (Application Date + N months)
  - Principal Portion
  - Interest Portion
  - Total Payment
  - Running Balance
```

---

## Approval Workflow

### Approval Process

**Step 1: Application Submission**
- Employee or HR creates loan application
- Status: Pending
- Notification sent to approvers

**Step 2: Review**
- Approver reviews loan details
- Checks employee eligibility
- Verifies loan amount and terms

**Step 3: Approval/Rejection**
- Approver approves or rejects
- Approval notes added
- Status updated
- Notification sent to employee

**Step 4: Disbursement**
- Finance team marks as disbursed
- Disbursement details recorded
- Status: Active
- Repayment schedule activated

### Approval Criteria

**Eligibility Checks**:
1. Employee must be active
2. Employee must have basic salary set
3. Monthly installment should not exceed 40% of salary
4. No existing defaulted loans
5. Minimum employment period (configurable)

**Approval Levels**:
- Loans up to KES 50,000: Department Manager
- Loans KES 50,001 - 200,000: HR Manager
- Loans above KES 200,000: Finance Director

---

## Repayment Management

### Automatic Payroll Deduction

**Process**:
1. During payroll generation
2. System checks for active loans
3. Calculates monthly installment
4. Deducts from gross salary
5. Records repayment
6. Updates loan balance

**Deduction Priority**:
1. Statutory deductions (PAYE, NHIF, NSSF)
2. Loan repayments
3. Other deductions

### Manual Repayment

**Steps**:
1. Navigate to loan details
2. Click "Record Payment"
3. Enter payment details:
   - Payment Date
   - Amount
   - Payment Method
   - Reference Number
4. Save payment
5. System updates balance

### Early Repayment

**Features**:
- Allow full or partial early repayment
- Recalculate remaining interest
- Update repayment schedule
- Close loan if fully paid

**Process**:
1. Employee requests early repayment
2. System calculates outstanding balance
3. Employee makes payment
4. Loan status updated to Completed

---

## Loan Settings

### Configurable Parameters

**Access**: Settings → Loan Settings

**Settings**:
1. **Maximum Loan Amount**
   - Per loan type
   - Based on salary multiple

2. **Interest Rates**
   - Default rates per loan type
   - Minimum and maximum rates

3. **Repayment Period**
   - Minimum months
   - Maximum months
   - Default period

4. **Eligibility Criteria**
   - Minimum employment period
   - Maximum salary deduction percentage
   - Maximum concurrent loans

5. **Approval Workflow**
   - Approval levels
   - Amount thresholds
   - Required approvers

6. **Disbursement Methods**
   - Available methods
   - Default method

---

## Reports

### Available Reports

1. **Loan Summary Report**
   - Total loans by status
   - Total amount disbursed
   - Total amount repaid
   - Outstanding balance

2. **Employee Loan Report**
   - Loans per employee
   - Repayment status
   - Default risk analysis

3. **Loan Type Report**
   - Breakdown by loan type
   - Average loan amount
   - Average interest rate

4. **Repayment Report**
   - Monthly repayments
   - Collection rate
   - Overdue loans

5. **Aging Report**
   - Loans by age
   - Overdue analysis
   - Default prediction

---

## API Endpoints

### List Loans
```http
GET /loans
```

**Query Parameters**:
- `employee_id` - Filter by employee
- `loan_type` - Filter by type
- `status` - Filter by status
- `from_date` - Start date
- `to_date` - End date

### Get Loan Details
```http
GET /loans/{id}
```

### Create Loan
```http
POST /loans
```

**Request Body**:
```json
{
  "employee_id": 1,
  "loan_type": "personal",
  "amount": 100000,
  "interest_rate": 10,
  "interest_type": "simple",
  "repayment_period": 12,
  "purpose": "Home renovation"
}
```

### Approve Loan
```http
POST /loans/{id}/approve
```

**Request Body**:
```json
{
  "approval_notes": "Approved based on salary and employment history"
}
```

### Reject Loan
```http
POST /loans/{id}/reject
```

**Request Body**:
```json
{
  "rejection_reason": "Exceeds maximum loan amount for salary grade"
}
```

### Disburse Loan
```http
POST /loans/{id}/disburse
```

**Request Body**:
```json
{
  "disbursement_date": "2024-02-15",
  "disbursement_method": "bank_transfer",
  "disbursement_reference": "TXN123456",
  "notes": "Transferred to employee bank account"
}
```

### Record Repayment
```http
POST /loans/{id}/repayments
```

**Request Body**:
```json
{
  "payment_date": "2024-03-01",
  "amount": 9166.67,
  "payment_method": "payroll_deduction",
  "reference": "PAY-2024-03"
}
```

---

## Integration with Payroll

### Automatic Deduction Process

**During Payroll Generation**:
1. System retrieves active loans for employee
2. Calculates total monthly deduction
3. Verifies sufficient net salary
4. Applies deduction
5. Records repayment
6. Updates loan balance
7. Checks if loan is fully paid

**Payroll Display**:
```
Gross Salary:        KES 80,000
Deductions:
  - PAYE:            KES 12,000
  - NHIF:            KES 1,700
  - NSSF:            KES 2,160
  - Loan Repayment:  KES 9,167
Total Deductions:    KES 25,027
Net Salary:          KES 54,973
```

---

## Notifications

### Email Notifications

**Triggers**:
1. **Loan Application Submitted**
   - To: Approvers
   - Content: Loan details, employee info

2. **Loan Approved**
   - To: Employee
   - Content: Approval details, next steps

3. **Loan Rejected**
   - To: Employee
   - Content: Rejection reason

4. **Loan Disbursed**
   - To: Employee
   - Content: Disbursement details, repayment schedule

5. **Payment Due Reminder**
   - To: Employee
   - Content: Upcoming payment, amount

6. **Payment Processed**
   - To: Employee
   - Content: Payment confirmation, remaining balance

7. **Loan Completed**
   - To: Employee
   - Content: Congratulations, loan closure

---

## Best Practices

### For HR/Finance
1. Verify employee eligibility before approval
2. Ensure loan terms are within policy
3. Document approval decisions
4. Monitor repayment rates
5. Follow up on overdue payments

### For Employees
1. Borrow only what you need
2. Understand repayment terms
3. Ensure timely repayments
4. Communicate if facing difficulties
5. Consider early repayment to save interest

---

## Troubleshooting

### Common Issues

**Issue**: Loan not deducted from payroll
- **Solution**: Check loan status is "Active", verify payroll period

**Issue**: Cannot approve loan
- **Solution**: Verify approval permissions, check loan status

**Issue**: Incorrect installment calculation
- **Solution**: Verify interest rate and type, check repayment period

**Issue**: Employee has multiple active loans
- **Solution**: Check loan settings for maximum concurrent loans

---

## Future Enhancements

- [ ] Loan calculator widget
- [ ] Loan restructuring
- [ ] Grace period support
- [ ] Penalty for late payment
- [ ] Loan guarantor system
- [ ] Mobile app integration
- [ ] SMS notifications
- [ ] Loan comparison tool

---

**Last Updated**: February 2026
