#!/bin/bash

echo "🚀 Starting Laravel deployment..."

# Install Composer dependencies
echo "📦 Running Composer install..."
composer install --no-dev --optimize-autoloader --ignore-platform-reqs

# Install NPM dependencies and build assets
echo "📦 Installing NPM dependencies..."
npm install
npm run build

# Setup .env if missing
echo "🔧 Setting up .env..."
# php -r "file_exists('.env') || copy('.env.example', '.env');"

# Generate app key
echo "🔑 Generating app key..."
php artisan key:generate

# Create sessions table migration if it doesn't exist
echo "📋 Creating sessions table migration..."
php artisan session:table

# Run migrations and seeders
echo "🛠️ Running migrations and seeders..."
php artisan migrate --force --seed

php artisan queue:work 
# php artisan queue:work --tries=1 --timeout=10 &



# Create necessary folders
echo "📁 Ensuring storage and cache directories exist..."
mkdir -p storage/framework/{cache,sessions,views}
mkdir -p storage/logs
mkdir -p bootstrap/cache

# Set permissions (Hostinger shared hosting compatible)
echo "🔐 Setting permissions..."
# Don't use chown on shared hosting - it will fail
chmod -R 755 storage bootstrap/cache public
chmod -R 755 public/storage
chmod 644 public/.htaccess
chmod 644 public/index.php

# Copy storage publicly (skip symlink)
echo "🔗 Linking storage (manual copy)..."
rm -rf public/storage
mkdir -p storage/app/public
cp -r storage/app/public public/storage

# Clear caches
echo "🧹 Clearing caches..."
php artisan cache:clear
php artisan view:clear
php artisan route:clear
php artisan config:clear

# Rebuild caches
echo "🧱 Rebuilding caches..."
php artisan view:cache
php artisan route:cache
php artisan config:cache

# Clear logs
truncate -s 0 storage/logs/laravel.log

# Test multitenancy
echo "🧪 Testing multitenancy setup..."
php artisan test:multitenancy

echo ""
echo "🎉 Qaya HRM Multitenancy setup completed!"
echo ""
echo "📋 Login Credentials:"
echo "SystemAdmin: systemadmin@example.com / password"
echo "Organization Admin: qayacreatives@gmail.com / password"
echo ""
echo "🌐 URLs:"
echo "SystemAdmin: /systemadmin/login"
echo "Organization Users: /login"
echo ""
echo "🛠️ Useful Commands:"
echo "Create Organization: php artisan org:create 'Company Name' admin@company.com"
echo "List Organizations: php artisan org:list"
echo "Test System: php artisan test:multitenancy"
echo ""
echo "✅ Deployment complete!"
