<?php

namespace Database\Seeders;

use App\Models\SubscriptionPlan;
use Illuminate\Database\Seeder;

class SubscriptionPlansSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Starter',
                'slug' => 'starter',
                'description' => 'Perfect for SMEs (5-25 employees) moving from Excel to professional HR software',
                'price_monthly' => 3000.00, // KES 3,000
                'price_annual' => 30000.00, // KES 30,000 (2 months free)
                'max_employees' => 25,
                'max_users' => 10,
                'max_departments' => 5,
                'storage_limit_gb' => 2,
                'max_file_size_mb' => 5,
                'api_call_limit' => null, // No API access
                'features' => [
                    'modules' => [
                        'employees',
                        'departments',
                        'positions',
                        'attendance', // Basic rules only
                        'leave',
                    ],
                    'reports' => 'pdf_only', // Limited PDF reports
                    'support' => 'email',
                    'employee_self_service' => true,
                    'email_notifications' => true,
                    'payroll_exports' => 'csv_only', // CSV only, no full processing
                    'bulk_imports' => false,
                    'custom_roles' => false, // Use defaults only
                    'advanced_attendance_rules' => false,
                    'document_storage_quota' => '2GB',
                    'users_can_self_register' => false,
                    'custom_fields' => false,
                    'advanced_reports' => false,
                    'api_access' => false,
                    'white_label' => false,
                    'custom_domain' => false,
                    'priority_support' => false,
                    'dedicated_manager' => false,
                ],
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Growth',
                'slug' => 'growth',
                'description' => 'Ideal for serious SMEs (25-100 employees) needing comprehensive HR features',
                'price_monthly' => 9500.00, // KES 9,500
                'price_annual' => 95000.00, // KES 95,000 (2 months free)
                'max_employees' => 100,
                'max_users' => 50,
                'max_departments' => 20,
                'storage_limit_gb' => 20,
                'max_file_size_mb' => 10,
                'api_call_limit' => 5000, // 5,000 API calls per month
                'features' => [
                    'modules' => [
                        'employees',
                        'departments',
                        'positions',
                        'attendance', // Full configuration
                        'leave',
                        'payroll', // Full processing
                        'performance',
                        'training',
                        'recruitment',
                    ],
                    'reports' => 'all', // PDF + Excel
                    'support' => 'priority',
                    'employee_self_service' => true,
                    'email_notifications' => true,
                    'payroll_exports' => 'full', // Full payroll processing
                    'bulk_imports' => true,
                    'bulk_exports' => true,
                    'custom_roles' => true,
                    'custom_permissions' => true,
                    'advanced_attendance_rules' => true,
                    'attendance_rule_configuration' => true,
                    'leave_calendar' => true, // FullCalendar
                    'document_management' => true,
                    'document_storage_quota' => '20GB',
                    'manager_approvals' => true,
                    'advanced_reports' => true,
                    'custom_reports' => false,
                    'api_access' => true,
                    'webhooks' => false,
                    'white_label' => false,
                    'custom_domain' => false,
                    'priority_support' => true,
                    'dedicated_manager' => false,
                    'sla' => '24_hours',
                ],
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Business',
                'slug' => 'business',
                'description' => 'For established organizations (100-250+ employees) requiring risk reduction & control',
                'price_monthly' => 25000.00, // KES 25,000
                'price_annual' => 250000.00, // KES 250,000 (2 months free)
                'max_employees' => 250,
                'max_users' => 100,
                'max_departments' => 50,
                'storage_limit_gb' => 100,
                'max_file_size_mb' => 50,
                'api_call_limit' => null, // Unlimited API calls
                'features' => [
                    'modules' => [
                        'employees',
                        'departments',
                        'positions',
                        'attendance',
                        'leave',
                        'payroll',
                        'performance',
                        'training',
                        'recruitment',
                        'advanced_analytics',
                    ],
                    'reports' => 'all',
                    'support' => 'dedicated',
                    'employee_self_service' => true,
                    'email_notifications' => true,
                    'payroll_exports' => 'full',
                    'bulk_imports' => true,
                    'bulk_exports' => true,
                    'custom_roles' => true,
                    'custom_permissions' => true,
                    'advanced_attendance_rules' => true,
                    'attendance_rule_configuration' => true,
                    'leave_calendar' => true,
                    'document_management' => true,
                    'document_storage_quota' => '100GB',
                    'manager_approvals' => true,
                    'advanced_reports' => true,
                    'custom_reports' => true,
                    'advanced_audit_logs' => true, // Enhanced audit logging
                    'approval_workflows' => true, // Custom approval workflows
                    'department_level_managers' => true,
                    'higher_quotas' => true,
                    'priority_support' => true,
                    'dedicated_onboarding' => true,
                    'data_export_guarantees' => true,
                    'sla_backed_uptime' => '99.9%',
                    'api_access' => true,
                    'webhooks' => true,
                    'white_label' => false,
                    'custom_domain' => false,
                    'custom_branding' => false,
                    'dedicated_manager' => true,
                    'sla' => '4_hours',
                    'custom_integrations' => false,
                    'advanced_security' => true,
                    'audit_logs' => 'unlimited',
                    'data_retention' => 'unlimited',
                    'multi_currency' => false,
                    'multi_language' => false,
                ],
                'is_active' => true,
                'sort_order' => 3,
            ],
        ];

        foreach ($plans as $plan) {
            SubscriptionPlan::updateOrCreate(
                ['slug' => $plan['slug']],
                $plan
            );
        }

        $this->command->info('✅ Subscription plans seeded successfully!');
        $this->command->info('   - Starter: KES 3,000/month (up to 25 employees)');
        $this->command->info('   - Growth: KES 9,500/month (up to 100 employees)');
        $this->command->info('   - Business: KES 25,000/month (up to 250 employees)');
    }
}
