<?php

namespace Database\Seeders;

use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Seeder;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create permissions
        $permissions = [
            // Employee permissions
            ['name' => 'view_employees', 'guard_name' => 'web'],
            ['name' => 'view_employee_details', 'guard_name' => 'web'],
            ['name' => 'create_employees', 'guard_name' => 'web'],
            ['name' => 'edit_employees', 'guard_name' => 'web'],
            ['name' => 'delete_employees', 'guard_name' => 'web'],
            ['name' => 'edit_own_profile', 'guard_name' => 'web'],

            // Department permissions
            ['name' => 'view_departments', 'guard_name' => 'web'],
            ['name' => 'create_departments', 'guard_name' => 'web'],
            ['name' => 'edit_departments', 'guard_name' => 'web'],
            ['name' => 'delete_departments', 'guard_name' => 'web'],

            // Attendance permissions
            ['name' => 'view_attendance', 'guard_name' => 'web'],
            ['name' => 'create_attendance', 'guard_name' => 'web'],
            ['name' => 'edit_attendance', 'guard_name' => 'web'],
            ['name' => 'delete_attendance', 'guard_name' => 'web'],

            // Leave permissions
            ['name' => 'view_leaves', 'guard_name' => 'web'],
            ['name' => 'create_leaves', 'guard_name' => 'web'],
            ['name' => 'create_leave_for_others', 'guard_name' => 'web'],
            ['name' => 'edit_leaves', 'guard_name' => 'web'],
            ['name' => 'delete_leaves', 'guard_name' => 'web'],
            ['name' => 'approve_leaves', 'guard_name' => 'web'],

            // Payroll permissions
            ['name' => 'view_payroll', 'guard_name' => 'web'],
            ['name' => 'create_payroll', 'guard_name' => 'web'],
            ['name' => 'edit_payroll', 'guard_name' => 'web'],
            ['name' => 'delete_payroll', 'guard_name' => 'web'],
            ['name' => 'manage_payroll', 'guard_name' => 'web'], // Approve, process, manage loans
            ['name' => 'approve_payroll', 'guard_name' => 'web'], // Hierarchical approval
            ['name' => 'process_payroll', 'guard_name' => 'web'], // Process approved payroll

            // Performance permissions
            ['name' => 'view_performance', 'guard_name' => 'web'],
            ['name' => 'create_performance', 'guard_name' => 'web'],
            ['name' => 'edit_performance', 'guard_name' => 'web'],
            ['name' => 'delete_performance', 'guard_name' => 'web'],

            // Report permissions
            ['name' => 'view_reports', 'guard_name' => 'web'],

            // Settings permissions
            ['name' => 'view_settings', 'guard_name' => 'web'],
            ['name' => 'edit_settings', 'guard_name' => 'web'],

            // Role permissions
            ['name' => 'view_roles', 'guard_name' => 'web'],
            ['name' => 'create_roles', 'guard_name' => 'web'],
            ['name' => 'edit_roles', 'guard_name' => 'web'],
            ['name' => 'delete_roles', 'guard_name' => 'web'],
            ['name' => 'manage_roles', 'guard_name' => 'web'], // General role management permission

            // Permission permissions
            ['name' => 'view_permissions', 'guard_name' => 'web'],
            ['name' => 'create_permissions', 'guard_name' => 'web'],
            ['name' => 'edit_permissions', 'guard_name' => 'web'],
            ['name' => 'delete_permissions', 'guard_name' => 'web'],

            // User management permissions
            ['name' => 'view_users', 'guard_name' => 'web'],
            ['name' => 'create_users', 'guard_name' => 'web'],
            ['name' => 'edit_users', 'guard_name' => 'web'],
            ['name' => 'delete_users', 'guard_name' => 'web'],
            ['name' => 'manage_user_roles', 'guard_name' => 'web'],

            // system admin permission
            ['name' => 'manage_system_admin', 'guard_name' => 'web'],

            // Organization management permissions
            ['name' => 'manage_organizations', 'guard_name' => 'web'],
            ['name' => 'view_organization_settings', 'guard_name' => 'web'],
            ['name' => 'edit_organization_settings', 'guard_name' => 'web'],
            ['name' => 'manage_organization_users', 'guard_name' => 'web'],

            // Training & Development permissions
            ['name' => 'view_training', 'guard_name' => 'web'],
            ['name' => 'manage_training', 'guard_name' => 'web'],
            ['name' => 'enroll_training', 'guard_name' => 'web'],
            ['name' => 'create_training_programs', 'guard_name' => 'web'],
            ['name' => 'edit_training_programs', 'guard_name' => 'web'],
            ['name' => 'delete_training_programs', 'guard_name' => 'web'],
            ['name' => 'manage_training_sessions', 'guard_name' => 'web'],
            ['name' => 'view_training_reports', 'guard_name' => 'web'],
            
            // Training Recommendations permissions
            ['name' => 'view_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'create_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'manage_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'respond_team_training_recommendations', 'guard_name' => 'web'],
            ['name' => 'view_all_training_recommendations', 'guard_name' => 'web'],
            
            // Learning Paths permissions
            ['name' => 'view_learning_paths', 'guard_name' => 'web'],
            ['name' => 'create_learning_paths', 'guard_name' => 'web'],
            ['name' => 'update_learning_paths', 'guard_name' => 'web'],
            ['name' => 'delete_learning_paths', 'guard_name' => 'web'],
            ['name' => 'view_inactive_learning_paths', 'guard_name' => 'web'],
            ['name' => 'enroll_others_learning_paths', 'guard_name' => 'web'],
            ['name' => 'manage_learning_path_enrollments', 'guard_name' => 'web'],
            ['name' => 'view_all_learning_path_progress', 'guard_name' => 'web'],
            
            // Training Performance Impact permissions
            ['name' => 'view_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'create_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'update_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'delete_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'view_all_training_performance_impacts', 'guard_name' => 'web'],
            ['name' => 'view_team_training_performance', 'guard_name' => 'web'],

            // Audit Log permissions
            ['name' => 'view_audit_logs', 'guard_name' => 'web'], // General audit permission
            ['name' => 'view_system_audit_logs', 'guard_name' => 'web'], // System admin only
            ['name' => 'view_organization_audit_logs', 'guard_name' => 'web'], // Organization users only
            ['name' => 'export_audit_logs', 'guard_name' => 'web'],
            ['name' => 'manage_audit_settings', 'guard_name' => 'web'], // System admin only
        ];

        foreach ($permissions as $permission) {
            Permission::create($permission);
        }

        // Create roles
        $systemAdmin = Role::create([
            'name' => 'system_admin',
            'guard_name' => 'web',
        ]);

        $orgAdmin = Role::create([
            'name' => 'org_admin',
            'guard_name' => 'web',
        ]);


        $hrManager = Role::create([
            'name' => 'hr_manager',
            'guard_name' => 'web',
        ]);

        $accountant = Role::create([
            'name' => 'accountant',
            'guard_name' => 'web',
        ]);

        $manager = Role::create([
            'name' => 'manager',
            'guard_name' => 'web',
        ]);

        $employee = Role::create([
            'name' => 'employee',
            'guard_name' => 'web',
        ]);

        // Assign permissions to SystemAdmin (ONLY system-level permissions for security & privacy)
        $systemAdmin->givePermissionTo([
            // System admin specific permissions ONLY
            'manage_system_admin',
            'manage_organizations',
            'view_system_audit_logs',
            'manage_audit_settings',
            'export_audit_logs',
            'view_audit_logs',
            
            // System-level user management (not organization-specific)
            // 'view_users', 'create_users', 'edit_users', 'delete_users', 'manage_user_roles',
            // 'view_roles', 'create_roles', 'edit_roles', 'delete_roles', 'manage_roles',
            // 'view_permissions', 'create_permissions', 'edit_permissions', 'delete_permissions',
            
            // System settings (not organization settings)
            // 'view_settings', 'edit_settings',
            
            // System reports
            // 'view_reports'
            
            // NOTE: System admin does NOT get any organization-specific permissions
            // This ensures complete separation for security and data privacy
        ]);

        // Assign permissions to Organization Admin (all except system admin permissions)
        $orgAdmin->givePermissionTo([
            'view_employees', 'view_employee_details', 'create_employees', 'edit_employees', 'delete_employees',
            'view_departments', 'create_departments', 'edit_departments', 'delete_departments',
            'view_attendance', 'create_attendance', 'edit_attendance', 'delete_attendance',
            'view_leaves', 'create_leaves', 'create_leave_for_others', 'edit_leaves', 'delete_leaves', 'approve_leaves',
            'view_payroll', 'create_payroll', 'edit_payroll', 'delete_payroll', 'manage_payroll', 'approve_payroll', 'process_payroll',
            'view_performance', 'create_performance', 'edit_performance', 'delete_performance',
            'view_reports', 'view_settings', 'edit_settings',
            'view_users', 'create_users', 'edit_users', 'delete_users', 'manage_user_roles',
            'view_roles', 'create_roles', 'edit_roles', 'delete_roles', 'manage_roles',
            'view_permissions', 'create_permissions', 'edit_permissions', 'delete_permissions',
            'view_organization_settings', 'edit_organization_settings', 'manage_organization_users',
            'view_training', 'manage_training', 'enroll_training', 'create_training_programs', 
            'edit_training_programs', 'delete_training_programs', 'manage_training_sessions', 'view_training_reports',
            'view_training_recommendations', 'create_training_recommendations', 'manage_training_recommendations',
            'view_all_training_recommendations', 'view_learning_paths', 'create_learning_paths', 'update_learning_paths',
            'delete_learning_paths', 'view_inactive_learning_paths', 'enroll_others_learning_paths',
            'manage_learning_path_enrollments', 'view_all_learning_path_progress', 'view_training_performance_impacts',
            'create_training_performance_impacts', 'update_training_performance_impacts', 'delete_training_performance_impacts',
            'view_all_training_performance_impacts',
            // Audit permissions for organization users
            'view_audit_logs', 'view_organization_audit_logs', 'export_audit_logs'
        ]);


        // Assign permissions to HR Manager
        $hrManager->givePermissionTo([
            'view_employees', 'view_employee_details', 'create_employees', 'edit_employees', 'delete_employees',
            'view_departments', 'create_departments', 'edit_departments', 'delete_departments',
            'view_attendance', 'create_attendance', 'edit_attendance', 'delete_attendance',
            'view_leaves', 'create_leaves', 'create_leave_for_others', 'edit_leaves', 'delete_leaves', 'approve_leaves',
            'view_performance', 'create_performance', 'edit_performance', 'delete_performance',
            'view_reports',
            'view_users', 'create_users', 'edit_users', 'manage_user_roles',
            'view_training', 'manage_training', 'create_training_programs', 
            'edit_training_programs', 'delete_training_programs', 'manage_training_sessions', 'view_training_reports',
            'view_training_recommendations', 'create_training_recommendations', 'manage_training_recommendations',
            'view_all_training_recommendations', 'view_learning_paths', 'create_learning_paths', 'update_learning_paths',
            'delete_learning_paths', 'view_inactive_learning_paths', 'enroll_others_learning_paths',
            'manage_learning_path_enrollments', 'view_all_learning_path_progress', 'view_training_performance_impacts',
            'create_training_performance_impacts', 'update_training_performance_impacts', 'delete_training_performance_impacts',
            'view_all_training_performance_impacts',
            // Audit permissions for HR Manager
            'view_audit_logs', 'view_organization_audit_logs', 'export_audit_logs'
            // Note: HR Manager does NOT have edit_settings, view_organization_settings, or manage_roles
        ]);

        // Assign permissions to Accountant
        $accountant->givePermissionTo([
            'view_payroll', 'create_payroll', 'edit_payroll', 'delete_payroll', 'manage_payroll', 'approve_payroll', 'process_payroll',
            'view_reports', 'view_employees'
        ]);

        // Assign permissions to Manager
        $manager->givePermissionTo([
            'view_employees', 'view_employee_details', 'view_departments', 'view_attendance',
            'view_leaves', 'approve_leaves', 'view_performance', 'view_reports',
            'view_training', 'enroll_training', 'view_training_recommendations', 'create_training_recommendations',
            'respond_team_training_recommendations', 'view_learning_paths', 'enroll_others_learning_paths',
            'view_team_training_performance', 'create_training_performance_impacts'
        ]);

        // Assign permissions to Employee
        $employee->givePermissionTo([
            'view_employees', 'view_leaves', 'create_leaves', 'view_attendance',
            'edit_own_profile', 'view_training', 'enroll_training', 'view_learning_paths'
        ]);
    }
}
