<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RecruitmentPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        // Create recruitment permissions
        $permissions = [
            // Job Postings
            'view_job_postings',
            'create_job_postings',
            'edit_job_postings',
            'delete_job_postings',
            
            // Applications
            'view_applications',
            'update_application_status',
            'screen_applications',
            'export_applications',
            
            // Interviews
            'schedule_interviews',
            'conduct_interviews',
            'score_interviews',
            
            // Recruitment Reports
            'view_recruitment_reports',
            'export_recruitment_reports',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // Assign permissions to existing roles
        $systemAdmin = Role::where('name', 'system_admin')->first();
        if ($systemAdmin) {
            $systemAdmin->givePermissionTo($permissions);
        }

        $orgAdmin = Role::where('name', 'org_admin')->first();
        if ($orgAdmin) {
            $orgAdmin->givePermissionTo($permissions);
        }

        $hrManager = Role::where('name', 'hr_manager')->first();
        if ($hrManager) {
            $hrManager->givePermissionTo([
                'view_job_postings',
                'create_job_postings',
                'edit_job_postings',
                'view_applications',
                'update_application_status',
                'screen_applications',
                'schedule_interviews',
                'conduct_interviews',
                'score_interviews',
                'view_recruitment_reports',
            ]);
        }

        $manager = Role::where('name', 'manager')->first();
        if ($manager) {
            $manager->givePermissionTo([
                'view_job_postings',
                'view_applications',
                'conduct_interviews',
                'score_interviews',
            ]);
        }
    }
}