<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class AnnouncementPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        // Create announcement permissions
        $permissions = [
            'view_announcements',
            'create_announcements',
            'edit_announcements',
            'delete_announcements',
            'manage_announcements',
        ];

        foreach ($permissions as $name) {
            Permission::firstOrCreate(['name' => $name]);
        }

        // Assign permissions to roles
        $systemAdminRole = Role::where('name', 'system_admin')->first();
        $orgAdminRole = Role::where('name', 'org_admin')->first();
        $hrManagerRole = Role::where('name', 'hr_manager')->first();
        $accountantRole = Role::where('name', 'accountant')->first();
        $managerRole = Role::where('name', 'manager')->first();
        $employeeRole = Role::where('name', 'employee')->first();

        if ($systemAdminRole) {
            $systemAdminRole->givePermissionTo([
                'view_announcements',
                'create_announcements',
                'edit_announcements',
                'delete_announcements',
                'manage_announcements'
            ]);
        }

        if ($orgAdminRole) {
            $orgAdminRole->givePermissionTo([
                'view_announcements',
                'create_announcements',
                'edit_announcements',
                'delete_announcements',
                'manage_announcements'
            ]);
        }

        if ($hrManagerRole) {
            $hrManagerRole->givePermissionTo([
                'view_announcements',
                'create_announcements',
                'edit_announcements',
                'delete_announcements',
                'manage_announcements'
            ]);
        }

        if ($accountantRole) {
            $accountantRole->givePermissionTo([
                'view_announcements'
            ]);
        }

        if ($managerRole) {
            $managerRole->givePermissionTo([
                'view_announcements',
                'create_announcements',
                'edit_announcements'
            ]);
        }

        if ($employeeRole) {
            $employeeRole->givePermissionTo([
                'view_announcements'
            ]);
        }

        $this->command->info('Announcement permissions created and assigned successfully!');
    }
}