<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add onboarding fields to users table
        Schema::table('users', function (Blueprint $table) {
            $table->timestamp('last_otp_sent_at')->nullable()->after('email_verified_at');
            $table->boolean('must_verify_email')->default(false)->after('last_otp_sent_at');
            $table->boolean('first_login_completed')->default(false)->after('must_verify_email');
            $table->string('initial_password')->nullable()->after('first_login_completed');
        });

        // Add onboarding fields to organizations table
        Schema::table('organizations', function (Blueprint $table) {
            $table->enum('onboarding_step', [
                'pending_verification',
                'email_verified',
                'plan_selection',
                'payment_pending',
                'completed'
            ])->default('pending_verification')->after('status');
            $table->timestamp('onboarding_completed_at')->nullable()->after('onboarding_step');
            $table->text('onboarding_notes')->nullable()->after('onboarding_completed_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'last_otp_sent_at',
                'must_verify_email',
                'first_login_completed',
                'initial_password'
            ]);
        });

        Schema::table('organizations', function (Blueprint $table) {
            $table->dropColumn([
                'onboarding_step',
                'onboarding_completed_at',
                'onboarding_notes'
            ]);
        });
    }
};
