<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // 1. ApplicationMessage - from applications
        if (Schema::hasTable('application_messages') && !Schema::hasColumn('application_messages', 'organization_id')) {
            Schema::table('application_messages', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE application_messages am
                INNER JOIN applications a ON am.application_id = a.id
                SET am.organization_id = a.organization_id
            ');
            
            Schema::table('application_messages', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 2. PayrollApproval - from payrolls
        if (Schema::hasTable('payroll_approvals') && !Schema::hasColumn('payroll_approvals', 'organization_id')) {
            Schema::table('payroll_approvals', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE payroll_approvals pa
                INNER JOIN payrolls p ON pa.payroll_id = p.id
                SET pa.organization_id = p.organization_id
            ');
            
            Schema::table('payroll_approvals', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 3. LoanRepayment - from employee_loans
        if (Schema::hasTable('loan_repayments') && !Schema::hasColumn('loan_repayments', 'organization_id')) {
            Schema::table('loan_repayments', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE loan_repayments lr
                INNER JOIN employee_loans el ON lr.loan_id = el.id
                SET lr.organization_id = el.organization_id
            ');
            
            Schema::table('loan_repayments', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 4. TrainingEnrollment - from employees
        if (Schema::hasTable('training_enrollments') && !Schema::hasColumn('training_enrollments', 'organization_id')) {
            Schema::table('training_enrollments', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE training_enrollments te
                INNER JOIN employees e ON te.employee_id = e.id
                SET te.organization_id = e.organization_id
            ');
            
            Schema::table('training_enrollments', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 5. TrainingRecommendation - from employees
        if (Schema::hasTable('training_recommendations') && !Schema::hasColumn('training_recommendations', 'organization_id')) {
            Schema::table('training_recommendations', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE training_recommendations tr
                INNER JOIN employees e ON tr.employee_id = e.id
                SET tr.organization_id = e.organization_id
            ');
            
            Schema::table('training_recommendations', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 6. PerformanceGoalProgress - from performance_goals
        if (Schema::hasTable('performance_goal_progress') && !Schema::hasColumn('performance_goal_progress', 'organization_id')) {
            Schema::table('performance_goal_progress', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE performance_goal_progress pgp
                INNER JOIN performance_goals pg ON pgp.performance_goal_id = pg.id
                SET pgp.organization_id = pg.organization_id
            ');
            
            Schema::table('performance_goal_progress', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 7. PerformanceCompetencyRating - from performance_reviews
        if (Schema::hasTable('performance_competency_ratings') && !Schema::hasColumn('performance_competency_ratings', 'organization_id')) {
            Schema::table('performance_competency_ratings', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE performance_competency_ratings pcr
                INNER JOIN performance_reviews pr ON pcr.performance_review_id = pr.id
                SET pcr.organization_id = pr.organization_id
            ');
            
            Schema::table('performance_competency_ratings', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 8. TrainingPerformanceImpact - from employees
        if (Schema::hasTable('training_performance_impacts') && !Schema::hasColumn('training_performance_impacts', 'organization_id')) {
            Schema::table('training_performance_impacts', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE training_performance_impacts tpi
                INNER JOIN employees e ON tpi.employee_id = e.id
                SET tpi.organization_id = e.organization_id
            ');
            
            Schema::table('training_performance_impacts', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 9. ApplicationStatusHistory - from applications
        if (Schema::hasTable('application_status_histories') && !Schema::hasColumn('application_status_histories', 'organization_id')) {
            Schema::table('application_status_histories', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE application_status_histories ash
                INNER JOIN applications a ON ash.application_id = a.id
                SET ash.organization_id = a.organization_id
            ');
            
            Schema::table('application_status_histories', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 10. PayrollApprovalWorkflow - from organizations (already has it, just ensure)
        if (Schema::hasTable('payroll_approval_workflows') && !Schema::hasColumn('payroll_approval_workflows', 'organization_id')) {
            Schema::table('payroll_approval_workflows', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
        }
        
        // 11. LearningPathEnrollment - from employees
        if (Schema::hasTable('learning_path_enrollments') && !Schema::hasColumn('learning_path_enrollments', 'organization_id')) {
            Schema::table('learning_path_enrollments', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE learning_path_enrollments lpe
                INNER JOIN employees e ON lpe.employee_id = e.id
                SET lpe.organization_id = e.organization_id
            ');
            
            Schema::table('learning_path_enrollments', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 12. LearningPathStep - from learning_paths
        if (Schema::hasTable('learning_path_steps') && !Schema::hasColumn('learning_path_steps', 'organization_id')) {
            Schema::table('learning_path_steps', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE learning_path_steps lps
                INNER JOIN learning_paths lp ON lps.learning_path_id = lp.id
                SET lps.organization_id = lp.organization_id
            ');
            
            Schema::table('learning_path_steps', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 13. InterviewQuestion - from interviews
        if (Schema::hasTable('interview_questions') && !Schema::hasColumn('interview_questions', 'organization_id')) {
            Schema::table('interview_questions', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE interview_questions iq
                INNER JOIN interviews i ON iq.interview_id = i.id
                SET iq.organization_id = i.organization_id
            ');
            
            Schema::table('interview_questions', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
        
        // 14. TrainingMaterial - from training_programs
        if (Schema::hasTable('training_materials') && !Schema::hasColumn('training_materials', 'organization_id')) {
            Schema::table('training_materials', function (Blueprint $table) {
                $table->foreignId('organization_id')->after('id')->nullable()->constrained()->onDelete('cascade');
                $table->index('organization_id');
            });
            
            DB::statement('
                UPDATE training_materials tm
                INNER JOIN training_programs tp ON tm.training_program_id = tp.id
                SET tm.organization_id = tp.organization_id
            ');
            
            Schema::table('training_materials', function (Blueprint $table) {
                $table->foreignId('organization_id')->nullable(false)->change();
            });
        }
    }

    public function down(): void
    {
        $tables = [
            'application_messages',
            'payroll_approvals',
            'loan_repayments',
            'training_enrollments',
            'training_recommendations',
            'performance_goal_progress',
            'performance_competency_ratings',
            'training_performance_impacts',
            'application_status_histories',
            'payroll_approval_workflows',
            'learning_path_enrollments',
            'learning_path_steps',
            'interview_questions',
            'training_materials'
        ];
        
        foreach ($tables as $table) {
            if (Schema::hasTable($table) && Schema::hasColumn($table, 'organization_id')) {
                Schema::table($table, function (Blueprint $blueprint) {
                    $blueprint->dropForeign(['organization_id']);
                    $blueprint->dropIndex(['organization_id']);
                    $blueprint->dropColumn('organization_id');
                });
            }
        }
    }
};
