<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('theme_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->constrained('organizations')->onDelete('cascade');
            
            // Base theme selection (falls back to config themes)
            $table->string('base_theme', 50)->default('default')->comment('Base theme from config: default, system_admin, blue, green');
            
            // Color Overrides (nullable = use base theme colors)
            $table->string('primary_color', 7)->nullable();
            $table->string('secondary_color', 7)->nullable();
            $table->string('accent_color', 7)->nullable();
            $table->string('success_color', 7)->nullable();
            $table->string('warning_color', 7)->nullable();
            $table->string('danger_color', 7)->nullable();
            $table->string('info_color', 7)->nullable();
            $table->string('light_color', 7)->nullable();
            $table->string('dark_color', 7)->nullable();
            
            // Sidebar Color Overrides
            $table->string('sidebar_bg_color', 50)->nullable();
            $table->string('sidebar_text_color', 50)->nullable();
            $table->string('sidebar_hover_color', 50)->nullable();
            $table->string('sidebar_active_color', 50)->nullable();
            
            // Fonts
            $table->string('primary_font', 100)->nullable()->comment('e.g., Segoe UI, Tahoma, Geneva');
            $table->string('heading_font', 100)->nullable()->comment('e.g., Arial, sans-serif');
            
            // Logo & Images
            $table->string('logo_url', 255)->nullable()->comment('Main logo URL');
            $table->string('sidebar_logo_url', 255)->nullable()->comment('Logo for sidebar (44x44px recommended)');
            $table->string('header_logo_url', 255)->nullable()->comment('Logo for header navbar (28px height)');
            $table->string('favicon_url', 255)->nullable()->comment('Browser tab favicon');
            $table->string('login_banner_url', 255)->nullable()->comment('Login page banner');
            
            // Layout Preferences
            $table->boolean('sidebar_collapsed_default')->default(false);
            $table->boolean('dark_mode_enabled')->default(false);
            
            // Advanced Customization
            $table->text('custom_css')->nullable()->comment('Custom CSS for advanced branding');
            
            // Metadata
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            
            // Indexes
            $table->unique('organization_id');
            $table->index(['organization_id', 'is_active']);
        });
        
        // Add theme preference to users table
        Schema::table('users', function (Blueprint $table) {
            $table->string('theme_preference', 50)->nullable()->after('remember_token')->comment('User personal theme preference');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('theme_preference');
        });
        
        Schema::dropIfExists('theme_settings');
    }
};
