<?php

namespace Database\Factories;

use App\Models\Application;
use App\Models\JobPosting;
use App\Models\Organization;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Application>
 */
class ApplicationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'job_posting_id' => JobPosting::factory(),
            'candidate_id' => null,
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone' => $this->faker->phoneNumber(),
            'cv_path' => 'applications/test/cv_' . $this->faker->uuid() . '.pdf',
            'cover_letter' => $this->faker->optional()->paragraphs(2, true),
            'status' => $this->faker->randomElement(['new', 'screening', 'shortlisted', 'interviewed', 'rejected', 'offered']),
            'screening_score' => $this->faker->optional()->randomFloat(2, 0, 100),
            'notes' => $this->faker->optional()->sentence(),
            'updated_count' => 0,
            'last_updated_at' => null,
            'tracking_token' => $this->faker->unique()->sha256(),
            'applied_at' => $this->faker->dateTimeBetween('-3 months', 'now'),
            'organization_id' => Organization::factory(),
        ];
    }

    /**
     * Indicate that the application is new.
     */
    public function new(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'new',
        ]);
    }

    /**
     * Indicate that the application is being screened.
     */
    public function screening(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'screening',
        ]);
    }

    /**
     * Indicate that the application is shortlisted.
     */
    public function shortlisted(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'shortlisted',
        ]);
    }

    /**
     * Indicate that the application has been interviewed.
     */
    public function interviewed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'interviewed',
        ]);
    }

    /**
     * Indicate that the application has been offered.
     */
    public function offered(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'offered',
        ]);
    }

    /**
     * Indicate that the application has been rejected.
     */
    public function rejected(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'rejected',
        ]);
    }
}