<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Kenya Payroll Configuration (Updated for 2026)
    |--------------------------------------------------------------------------
    |
    | Configuration for Kenya Revenue Authority (KRA) compliance
    | and statutory deductions as per Kenya Employment Act
    | Updated to reflect current regulations as of February 2026
    |
    */

    'employer' => [
        'kra_pin' => env('EMPLOYER_KRA_PIN', ''),
        'shif_employer_code' => env('SHIF_EMPLOYER_CODE', ''), // Replaced NHIF
        'nssf_employer_code' => env('NSSF_EMPLOYER_CODE', ''),
        'company_name' => env('APP_NAME', 'Company Name'),
    ],

    'tax_rates' => [
        'paye_bands' => [
            ['min' => 0, 'max' => 24000, 'rate' => 0.10],
            ['min' => 24001, 'max' => 32333, 'rate' => 0.25],
            ['min' => 32334, 'max' => 500000, 'rate' => 0.30],
            ['min' => 500001, 'max' => 800000, 'rate' => 0.325],
            ['min' => 800001, 'max' => PHP_INT_MAX, 'rate' => 0.35],
        ],
        'personal_relief' => 2400, // Monthly
        'insurance_relief_rate' => 0.15,
        'insurance_relief_max' => 5000, // Monthly
        'pension_relief_max' => 20000, // Monthly
        'pension_relief_rate' => 0.30, // 30% of pensionable pay
    ],

    /*
    |--------------------------------------------------------------------------
    | SHIF (Social Health Insurance Fund) - Replaced NHIF October 1, 2024
    |--------------------------------------------------------------------------
    */
    'shif' => [
        'rate' => 0.0275, // 2.75% of gross salary
        'min_contribution' => 300, // Minimum monthly contribution
        'tax_deductible' => true, // Fully tax-deductible as of Dec 27, 2024
        'effective_date' => '2024-10-01',
    ],

    /*
    |--------------------------------------------------------------------------
    | NSSF (Updated rates for 2026)
    |--------------------------------------------------------------------------
    */
    'nssf' => [
        'employee_rate' => 0.06, // 6%
        'employer_rate' => 0.06, // 6%
        'lower_limit' => 9000, // February 2026 rate (up from 8,000)
        'upper_limit' => 108000, // February 2026 rate (up from 72,000)
        'max_employee_contribution' => 6480, // 6% of 108,000
        'max_employer_contribution' => 6480, // 6% of 108,000
        'min_contribution' => 540, // 6% of 9,000
        'tax_deductible' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Housing Levy (Updated for 2026)
    |--------------------------------------------------------------------------
    */
    'housing_levy' => [
        'employee_rate' => 0.015, // 1.5%
        'employer_rate' => 0.015, // 1.5%
        'tax_deductible' => true, // Fully tax-deductible as of Dec 27, 2024
        'no_max_cap' => true, // No maximum contribution cap
    ],

    /*
    |--------------------------------------------------------------------------
    | Legacy NHIF (Obsolete as of October 1, 2024)
    |--------------------------------------------------------------------------
    | Kept for historical payroll records only
    */
    'nhif_legacy' => [
        'obsolete_date' => '2024-10-01',
        'replaced_by' => 'SHIF',
        'rates' => [
            ['min' => 0, 'max' => 5999, 'amount' => 150],
            ['min' => 6000, 'max' => 7999, 'amount' => 300],
            ['min' => 8000, 'max' => 11999, 'amount' => 400],
            ['min' => 12000, 'max' => 14999, 'amount' => 500],
            ['min' => 15000, 'max' => 19999, 'amount' => 600],
            ['min' => 20000, 'max' => 24999, 'amount' => 750],
            ['min' => 25000, 'max' => 29999, 'amount' => 850],
            ['min' => 30000, 'max' => 34999, 'amount' => 900],
            ['min' => 35000, 'max' => 39999, 'amount' => 950],
            ['min' => 40000, 'max' => 44999, 'amount' => 1000],
            ['min' => 45000, 'max' => 49999, 'amount' => 1100],
            ['min' => 50000, 'max' => 59999, 'amount' => 1200],
            ['min' => 60000, 'max' => 69999, 'amount' => 1300],
            ['min' => 70000, 'max' => 79999, 'amount' => 1400],
            ['min' => 80000, 'max' => 89999, 'amount' => 1500],
            ['min' => 90000, 'max' => 99999, 'amount' => 1600],
            ['min' => 100000, 'max' => PHP_INT_MAX, 'amount' => 1700],
        ],
    ],

    'allowances' => [
        'default_house_allowance_rate' => 0.15, // 15% of basic salary
        'default_transport_allowance_rate' => 0.05, // 5% of basic salary
        'max_transport_allowance' => 5000, // Monthly maximum
        'default_medical_allowance' => 2000, // Fixed amount
    ],

    'working_days' => [
        'default_monthly' => 22,
        'default_weekly' => 5,
        'default_hours_per_day' => 8,
    ],

    'compliance' => [
        'kra_submission_deadline' => 9, // 9th of following month
        'shif_submission_deadline' => 15, // 15th of following month (replaced NHIF)
        'nssf_submission_deadline' => 15, // 15th of following month
        'housing_levy_submission_deadline' => 9, // 9th of following month
        'p9_generation_period' => 'yearly', // Annual P9 forms
    ],

    /*
    |--------------------------------------------------------------------------
    | Configuration Versioning
    |--------------------------------------------------------------------------
    */
    'version' => '2026.02',
    'last_updated' => '2026-02-05',
    'regulatory_changes' => [
        '2024-10-01' => 'NHIF replaced by SHIF',
        '2024-12-27' => 'SHIF and Housing Levy became tax-deductible',
        '2025-02-01' => 'NSSF limits increased to 8,000-72,000',
        '2026-02-01' => 'NSSF limits increased to 9,000-108,000',
    ],
];