<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Audit Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration options for the audit logging system
    |
    */

    // Enable/disable audit logging globally
    'enabled' => env('AUDIT_ENABLED', true),

    // Use queue for audit logging (recommended for production)
    'use_queue' => env('AUDIT_USE_QUEUE', false),

    // Queue name for audit logs
    'queue_name' => env('AUDIT_QUEUE_NAME', 'audit'),

    // Enable audit logging in console commands
    'console_enabled' => env('AUDIT_CONSOLE_ENABLED', false),

    // Data retention settings
    'retention' => [
        // Default retention period in days (0 = keep forever)
        'default_days' => env('AUDIT_RETENTION_DAYS', 365),
        
        // Retention by category (overrides default)
        'by_category' => [
            'authentication' => 90,
            'security' => 730, // 2 years
            'compliance' => 2555, // 7 years
            'data_modification' => 365,
            'data_access' => 30,
            'system_admin' => 365,
        ],
    ],

    // Performance settings
    'performance' => [
        // Batch size for bulk operations
        'batch_size' => 1000,
        
        // Enable database partitioning (requires manual setup)
        'use_partitioning' => env('AUDIT_USE_PARTITIONING', false),
        
        // Cache frequently accessed data
        'cache_enabled' => env('AUDIT_CACHE_ENABLED', true),
        'cache_ttl' => 3600, // 1 hour
    ],

    // Export settings
    'export' => [
        // Maximum records per export
        'max_records' => 50000,
        
        // Allowed export formats
        'formats' => ['csv', 'xlsx'],
        
        // Export queue (for large exports)
        'use_queue' => true,
        'queue_name' => 'exports',
    ],

    // Security settings
    'security' => [
        // Hash sensitive data in audit logs
        'hash_sensitive_data' => true,
        
        // Sensitive fields to hash
        'sensitive_fields' => [
            'password',
            'ssn',
            'tax_id',
            'bank_account',
            'credit_card',
        ],
        
        // Enable audit log integrity checking
        'integrity_check' => env('AUDIT_INTEGRITY_CHECK', false),
    ],

    // Models to automatically audit
    'auto_audit_models' => [
        'App\Models\User',
        'App\Models\Employee',
        'App\Models\Organization',
        'App\Models\Department',
        'App\Models\JobPosting',
        'App\Models\Application',
        'App\Models\Interview',
        'App\Models\LeaveRequest',
        'App\Models\Payroll',
        'App\Models\PerformanceReview',
        'App\Models\TrainingSession',
        'App\Models\Document',
    ],

    // Event types configuration
    'event_types' => [
        'authentication' => [
            'login',
            'logout',
            'login_failed',
            'password_reset',
            'email_verified',
        ],
        'data_modification' => [
            'created',
            'updated',
            'deleted',
            'restored',
            'bulk_update',
            'bulk_delete',
        ],
        'data_access' => [
            'viewed',
            'downloaded',
            'exported',
            'searched',
        ],
        'authorization' => [
            'permission_granted',
            'permission_denied',
            'role_assigned',
            'role_removed',
        ],
        'system_admin' => [
            'settings_changed',
            'user_impersonated',
            'maintenance_mode',
            'cache_cleared',
        ],
        'security' => [
            'suspicious_activity',
            'multiple_failed_logins',
            'unauthorized_access',
            'data_breach_attempt',
        ],
        'compliance' => [
            'data_export_request',
            'data_deletion_request',
            'consent_given',
            'consent_withdrawn',
        ],
    ],
];