<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use App\Services\ThemeService;

class ThemeServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register ThemeService as singleton
        $this->app->singleton(ThemeService::class, function ($app) {
            return new ThemeService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Register Blade directives for easy theme access
        Blade::directive('themeColor', function ($expression) {
            return "<?php echo \$themeConfig['colors'][{$expression}] ?? '#000000'; ?>";
        });
        
        // Register component aliases
        Blade::component('components.stat-card', 'stat-card');
        Blade::component('components.table-card', 'table-card');
        Blade::component('components.badge', 'app-badge');
    }
}
