<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;

class TenantServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register tenant context resolver
        $this->app->singleton('tenant.context', function ($app) {
            return new \App\Services\TenantContext();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Boot tenant context after authentication
        $this->app->booted(function () {
            if (Auth::check()) {
                $this->app->make('tenant.context')->resolve();
            }
        });
    }
}