<?php

namespace App\Policies;

use App\Models\User;
use App\Models\TrainingSession;

class TrainingSessionPolicy
{
    public function viewAny(User $user): bool
    {
        return $user->can('view_training') || 
               $user->can('manage_training_sessions') || 
               $user->can('manage_training');
    }

    public function view(User $user, TrainingSession $session): bool
    {
        return $user->organization_id === $session->organization_id &&
               ($user->can('view_training') || 
                $user->can('manage_training_sessions') || 
                $user->can('manage_training'));
    }

    public function create(User $user): bool
    {
        return $user->can('manage_training_sessions') || $user->can('manage_training');
    }

    public function update(User $user, TrainingSession $session): bool
    {
        return $user->organization_id === $session->organization_id &&
               ($user->can('manage_training_sessions') || $user->can('manage_training'));
    }

    public function delete(User $user, TrainingSession $session): bool
    {
        return $user->organization_id === $session->organization_id &&
               ($user->can('manage_training_sessions') || $user->can('manage_training'));
    }
}