<?php

namespace App\Policies;

use App\Models\User;
use App\Models\TrainingPerformanceImpact;

class TrainingPerformanceImpactPolicy
{
    public function viewAny(User $user)
    {
        return $user->can('view_training_performance_impacts') ||
               $user->can('manage_training') ||
               $user->hasRole(['HR Manager', 'Training Manager']);
    }

    public function view(User $user, TrainingPerformanceImpact $impact)
    {
        // Users can view impacts for their own training
        if ($user->employee && $user->employee->id === $impact->employee_id) {
            return true;
        }

        // Managers can view impacts for their team members
        if ($user->can('view_team_training_performance')) {
            $employee = $impact->employee;
            if ($employee && $employee->manager_id === $user->employee?->id) {
                return true;
            }
        }

        return $user->can('view_all_training_performance_impacts') ||
               $user->can('manage_training') ||
               $user->hasRole(['HR Manager', 'Training Manager']);
    }

    public function create(User $user)
    {
        return $user->can('create_training_performance_impacts') ||
               $user->can('manage_training') ||
               $user->hasRole(['HR Manager', 'Training Manager', 'Manager']);
    }

    public function update(User $user, TrainingPerformanceImpact $impact)
    {
        // Only the person who measured it or authorized users can update
        if ($impact->measured_by === $user->id) {
            return true;
        }

        return $user->can('update_training_performance_impacts') ||
               $user->can('manage_training') ||
               $user->hasRole(['HR Manager', 'Training Manager']);
    }

    public function delete(User $user, TrainingPerformanceImpact $impact)
    {
        return $user->can('delete_training_performance_impacts') ||
               $user->can('manage_training') ||
               $user->hasRole(['HR Manager', 'Training Manager']);
    }
}