<?php

namespace App\Policies;

use App\Models\PerformanceReview;
use App\Models\User;

class PerformanceReviewPolicy
{
    /**
     * Determine whether the user can view any performance reviews.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('view_performance');
    }

    /**
     * Determine whether the user can view the performance review.
     */
    public function view(User $user, PerformanceReview $performanceReview): bool
    {
        // Users can view their own performance reviews
        if ($user->employee && $user->employee->id === $performanceReview->employee_id) {
            return true;
        }

        return $user->can('view_performance');
    }

    /**
     * Determine whether the user can create performance reviews.
     */
    public function create(User $user): bool
    {
        return $user->can('create_performance');
    }

    /**
     * Determine whether the user can update the performance review.
     */
    public function update(User $user, PerformanceReview $performanceReview): bool
    {
        return $user->can('edit_performance');
    }

    /**
     * Determine whether the user can delete the performance review.
     */
    public function delete(User $user, PerformanceReview $performanceReview): bool
    {
        return $user->can('delete_performance');
    }

    /**
     * Determine whether the user can restore the performance review.
     */
    public function restore(User $user, PerformanceReview $performanceReview): bool
    {
        return $user->can('delete_performance');
    }

    /**
     * Determine whether the user can permanently delete the performance review.
     */
    public function forceDelete(User $user, PerformanceReview $performanceReview): bool
    {
        return $user->can('delete_performance');
    }
}
