<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class TrainingMaterial extends Model
{
    use HasTenantScope;

    protected $fillable = [
        'training_program_id',
        'organization_id',
        'title',
        'description',
        'type',
        'file_path',
        'external_url',
        'order_index',
        'is_required',
        'is_downloadable',
    ];

    protected $casts = [
        'is_required' => 'boolean',
        'is_downloadable' => 'boolean',
    ];

    public function program()
    {
        return $this->belongsTo(TrainingProgram::class, 'training_program_id');
    }

    public function scopeRequired($query)
    {
        return $query->where('is_required', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('order_index');
    }

    public function getFileUrlAttribute()
    {
        if ($this->file_path) {
            return asset('storage/' . $this->file_path);
        }
        return $this->external_url;
    }

    public function getTypeIconAttribute()
    {
        return match($this->type) {
            'document' => 'bi bi-file-alt',
            'video' => 'bi bi-video',
            'presentation' => 'bi bi-presentation',
            'link' => 'bi bi-external-link-alt',
            'quiz' => 'bi bi-question-circle',
            'assignment' => 'bi bi-tasks',
            default => 'bi bi-file'
        };
    }
}