<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class TrainingCategory extends Model
{
    use HasTenantScope;

    protected $fillable = [
        'name',
        'description',
        'color',
        'is_active',
        'organization_id',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function trainingPrograms()
    {
        return $this->hasMany(TrainingProgram::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}