<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class PerformanceGoalProgress extends Model
{
    use HasFactory, HasTenantScope;

    protected $fillable = [
        'performance_goal_id',
        'organization_id',
        'updated_by',
        'progress_percentage',
        'achieved_value',
        'update_notes',
        'milestone_updates',
        'update_date',
    ];

    protected $casts = [
        'progress_percentage' => 'decimal:2',
        'achieved_value' => 'decimal:2',
        'milestone_updates' => 'array',
        'update_date' => 'date',
    ];

    public function performanceGoal()
    {
        return $this->belongsTo(PerformanceGoal::class);
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}