<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Traits\HasTenantScope;

class PayrollApproval extends Model
{
    use HasFactory, HasTenantScope;

    protected $fillable = [
        'payroll_id',
        'organization_id',
        'level',
        'approver_role',
        'approver_id',
        'status',
        'approved_at',
        'comments',
    ];

    protected $casts = [
        'approved_at' => 'datetime',
    ];

    public function payroll(): BelongsTo
    {
        return $this->belongsTo(Payroll::class);
    }

    public function approver(): BelongsTo
    {
        return $this->belongsTo(User::class, 'approver_id');
    }

    /**
     * Check if this approval is pending
     */
    public function isPending(): bool
    {
        return $this->status === 'pending';
    }

    /**
     * Check if this approval is approved
     */
    public function isApproved(): bool
    {
        return $this->status === 'approved';
    }

    /**
     * Check if this approval is rejected
     */
    public function isRejected(): bool
    {
        return $this->status === 'rejected';
    }
}
