<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasTenantScope;

class InterviewQuestion extends Model
{
    use HasFactory, HasTenantScope;

    protected $fillable = [
        'interview_id',
        'organization_id',
        'question',
        'score',
        'max_score',
        'notes',
    ];

    protected $casts = [
        'score' => 'decimal:2',
        'max_score' => 'decimal:2',
    ];

    /**
     * Get the interview that owns the question
     */
    public function interview()
    {
        return $this->belongsTo(Interview::class);
    }

    /**
     * Get the percentage score
     */
    public function getPercentageScoreAttribute()
    {
        if ($this->max_score > 0 && $this->score !== null) {
            return ($this->score / $this->max_score) * 100;
        }
        return null;
    }

    /**
     * Check if question is scored
     */
    public function isScored()
    {
        return $this->score !== null;
    }
}