<?php

namespace App\Mail;

use App\Models\User;
use App\Models\Employee;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Mail\Concerns\UsesOrganizationMailSettings;

class WelcomeNewEmployee extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels, UsesOrganizationMailSettings;

    public $user;
    public $employee;

    public function __construct(User $user, Employee $employee)
    {
        $this->user = $user;
        $this->employee = $employee;
    }

    /**
     * Get the organization for mail configuration
     */
    protected function getOrganization()
    {
        return $this->user->organization ?? null;
    }

    public function envelope(): Envelope
    {
        $organization = $this->user->organization;
        
        $fromAddress = $organization && $organization->use_custom_mail && $organization->mail_from_address
            ? $organization->mail_from_address
            : config('mail.from.address');
            
        $fromName = $organization && $organization->use_custom_mail && $organization->mail_from_name
            ? $organization->mail_from_name
            : $organization->name;

        return new Envelope(
            subject: 'Welcome to ' . $organization->name,
            from: $fromAddress,
            replyTo: $fromAddress,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.welcome-new-employee',
            with: [
                'user' => $this->user,
                'employee' => $this->employee,
                'loginUrl' => route('login'),
            ]
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
