<?php

namespace App\Mail;

use App\Models\Application;
use App\Models\ApplicationMessage;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Mail\Concerns\UsesOrganizationMailSettings;

class NewMessageFromCandidate extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels, UsesOrganizationMailSettings;

    public $application;
    public $message;

    public function __construct(Application $application, ApplicationMessage $message)
    {
        $this->application = $application;
        $this->message = $message;
    }

    /**
     * Get the organization for mail configuration
     */
    protected function getOrganization()
    {
        return $this->application->jobPosting->organization ?? null;
    }

    public function envelope(): Envelope
    {
        $organization = $this->application->jobPosting->organization ?? null;
        
        $fromAddress = $organization && $organization->use_custom_mail && $organization->mail_from_address
            ? $organization->mail_from_address
            : config('mail.from.address');
            
        $fromName = $organization && $organization->use_custom_mail && $organization->mail_from_name
            ? $organization->mail_from_name
            : ($organization ? $organization->name : config('mail.from.name'));

        return new Envelope(
            subject: "New Message from {$this->application->full_name}",
            from: $fromAddress,
            replyTo: $fromAddress,
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'emails.new-message-from-candidate',
            with: [
                'application' => $this->application,
                'message' => $this->message,
                'applicationUrl' => route('job-postings.show', $this->application->job_posting_id) . '#applications',
            ]
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
