<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Mail\Concerns\UsesOrganizationMailSettings;
use App\Models\Interview;
use App\Models\Application;

class InterviewScheduled extends Mailable
{
    use Queueable, SerializesModels, UsesOrganizationMailSettings;

    public $interview;
    public $application;
    public $confirmationUrl;

    /**
     * Create a new message instance.
     */
    public function __construct(Interview $interview, Application $application)
    {
        $this->interview = $interview;
        $this->application = $application;
        $this->confirmationUrl = route('interview.show', ['token' => $interview->confirmation_token]);
    }

    /**
     * Get the organization for mail configuration
     */
    protected function getOrganization()
    {
        return $this->application->jobPosting->organization ?? null;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Interview Scheduled - ' . $this->application->jobPosting->title,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.interview-scheduled',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}

