<?php

namespace App\Mail\Concerns;

use App\Services\OrganizationMailService;
use Symfony\Component\Mime\Email;

trait UsesOrganizationMailSettings
{
    /**
     * Configure organization mail settings before sending
     */
    public function build()
    {
        $organization = $this->getOrganization();
        
        if ($organization && $organization->use_custom_mail) {
            OrganizationMailService::configureForOrganization($organization);
        }
        
        return $this;
    }

    /**
     * Get the organization from the mailable
     * This method should be implemented by the mailable class
     */
    abstract protected function getOrganization();
}
