<?php

namespace App\Http\Controllers;

use App\Models\Interview;
use Illuminate\Http\Request;

class InterviewConfirmationController extends Controller
{
    public function show($token)
    {
        $interview = Interview::where('confirmation_token', $token)
            ->with(['application', 'application.jobPosting', 'interviewer'])
            ->firstOrFail();

        return view('candidate.interview.confirm', compact('interview'));
    }

    public function confirm($token)
    {
        $interview = Interview::where('confirmation_token', $token)->firstOrFail();

        if ($interview->candidate_response !== 'pending') {
            return redirect()->route('interview.show', $token)
                ->with('info', 'You have already responded to this interview invitation.');
        }

        $interview->update([
            'candidate_response' => 'confirmed',
            'candidate_responded_at' => now(),
        ]);

        return view('candidate.interview.confirmed', compact('interview'));
    }

    public function decline(Request $request, $token)
    {
        $interview = Interview::where('confirmation_token', $token)->firstOrFail();

        if ($interview->candidate_response !== 'pending') {
            return redirect()->route('interview.show', $token)
                ->with('info', 'You have already responded to this interview invitation.');
        }

        $interview->update([
            'candidate_response' => 'declined',
            'candidate_responded_at' => now(),
            'candidate_notes' => $request->reason,
        ]);

        return view('candidate.interview.declined', compact('interview'));
    }
}
