<?php

namespace App\Exports;

use App\Models\Employee;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class EmployeesExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    protected $query;

    public function __construct($query = null)
    {
        $this->query = $query;
    }

    public function collection()
    {
        if ($this->query) {
            return $this->query->with(['department', 'position'])->get();
        }
        return Employee::with(['department', 'position'])->get();
    }

    public function headings(): array
    {
        return [
            'Employee Code',
            'First Name',
            'Last Name',
            'Email',
            'Phone',
            'Department',
            'Position',
            'Join Date',
            'Status',
            'Manager',
            'KRA PIN',
            'NHIF Number',
            'NSSF Number',
            'Basic Salary',
            'Emergency Contact',
            'Emergency Phone',
            'Bank Name',
            'Bank Account',
        ];
    }

    public function map($employee): array
    {
        return [
            $employee->employee_code,
            $employee->first_name,
            $employee->last_name,
            $employee->email,
            $employee->phone,
            $employee->department?->name,
            $employee->position?->name,
            $employee->joining_date?->format('Y-m-d'),
            $employee->status,
            $employee->manager?->first_name . ' ' . $employee->manager?->last_name,
            $employee->kra_pin,
            $employee->nhif_number,
            $employee->nssf_number,
            $employee->basic_salary,
            $employee->emergency_contact_name,
            $employee->emergency_contact_phone,
            $employee->bank_name,
            $employee->bank_account_number,
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
