<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Application;

class FixApplicationCvPaths extends Command
{
    protected $signature = 'fix:cv-paths';
    protected $description = 'Fix CV file paths for existing applications';

    public function handle()
    {
        $this->info('Fixing CV paths for existing applications...');

        $applications = Application::whereNotNull('cv_path')->get();

        foreach ($applications as $application) {
            $oldPath = $application->cv_path;
            
            // Remove 'public/' prefix if it exists
            $newPath = str_replace('public/', '', $oldPath);
            
            if ($oldPath !== $newPath) {
                $application->update(['cv_path' => $newPath]);
                $this->line("Fixed: {$oldPath} -> {$newPath}");
            }
        }

        $this->info('CV paths fixed successfully!');
    }
}